/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.identification.DefaultOperationMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.util.InternationalString;

@TitleProperty(name="name")
@XmlType(name="SV_OperationChainMetadata_Type", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", propOrder={"name", "description", "operations"})
@XmlRootElement(name="SV_OperationChainMetadata", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
@UML(identifier="SV_OperationChainMetadata", specification=Specification.ISO_19115)
public class DefaultOperationChainMetadata
extends ISOMetadata {
    private static final long serialVersionUID = 4132508877114835286L;
    private InternationalString name;
    private InternationalString description;
    private List<DefaultOperationMetadata> operations;

    public DefaultOperationChainMetadata() {
    }

    public DefaultOperationChainMetadata(CharSequence name) {
        this.name = Types.toInternationalString(name);
    }

    public DefaultOperationChainMetadata(DefaultOperationChainMetadata object) {
        super(object);
        if (object != null) {
            this.name = object.getName();
            this.description = object.getDescription();
            this.operations = this.copyList(object.getOperations(), DefaultOperationMetadata.class);
        }
    }

    @XmlElement(name="name", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", required=true)
    @UML(identifier="name", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString newValue) {
        this.checkWritePermission(this.name);
        this.name = newValue;
    }

    @XmlElement(name="description", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
    @UML(identifier="description", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission(this.description);
        this.description = newValue;
    }

    @XmlElement(name="operation", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", required=true)
    @UML(identifier="operation", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public List<DefaultOperationMetadata> getOperations() {
        this.operations = this.nonNullList(this.operations, DefaultOperationMetadata.class);
        return this.operations;
    }

    public void setOperations(List<? extends DefaultOperationMetadata> newValues) {
        this.operations = this.writeList(newValues, this.operations, DefaultOperationMetadata.class);
    }
}

