/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.geoapi.evolution.InterimType;
import org.apache.sis.internal.geoapi.evolution.UnsupportedCodeList;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.code.CI_TelephoneTypeCode;
import org.apache.sis.internal.jaxb.gco.StringAdapter;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.LegacyTelephones;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Telephone;
import org.opengis.util.CodeList;

@XmlType(name="CI_Telephone_Type", propOrder={"number", "numberType", "voices", "facsimiles"})
@XmlRootElement(name="CI_Telephone")
public class DefaultTelephone
extends ISOMetadata
implements Telephone {
    private static final long serialVersionUID = 5156405432420742237L;
    private String number;
    CodeList<?> numberType;
    @Deprecated
    private Collection<Telephone> owner;

    public DefaultTelephone() {
    }

    DefaultTelephone(String number, CodeList<?> numberType) {
        this.number = number;
        this.numberType = numberType;
    }

    public DefaultTelephone(Telephone object) {
        super(object);
        if (object != null) {
            if (object instanceof DefaultTelephone) {
                this.number = ((DefaultTelephone)object).getNumber();
                this.numberType = ((DefaultTelephone)object).numberType;
            } else {
                this.setVoices(object.getVoices());
                this.setFacsimiles(object.getFacsimiles());
            }
        }
    }

    public static DefaultTelephone castOrCopy(Telephone object) {
        if (object == null || object instanceof DefaultTelephone) {
            return (DefaultTelephone)object;
        }
        return new DefaultTelephone(object);
    }

    @XmlElement(name="number", required=true)
    @XmlJavaTypeAdapter(value=StringAdapter.Since2014.class)
    @UML(identifier="number", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String newValue) {
        this.checkWritePermission(this.number);
        this.number = newValue;
    }

    @InterimType(value=UnsupportedCodeList.class)
    @XmlElement(name="numberType")
    @XmlJavaTypeAdapter(value=CI_TelephoneTypeCode.Since2014.class)
    @UML(identifier="numberType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public CodeList<?> getNumberType() {
        return this.numberType;
    }

    public void setNumberType(CodeList<?> newValue) {
        this.checkWritePermission(this.numberType);
        this.numberType = newValue;
    }

    final DefaultTelephone setOwner(Collection<Telephone> phones) {
        if (this.owner != phones) {
            if (this.owner != null && !CollectionsExt.identityEquals(this.owner.iterator(), phones.iterator())) {
                DefaultTelephone copy = new DefaultTelephone(this);
                copy.owner = phones;
                return copy;
            }
            this.owner = phones;
        }
        return this;
    }

    final Collection<Telephone> getOwner() {
        if (this.owner == null) {
            if (super.state() != ModifiableMetadata.State.FINAL) {
                this.owner = new ArrayList<Telephone>(4);
                this.owner.add(this);
            } else {
                this.owner = Collections.singletonList(this);
            }
        }
        return this.owner;
    }

    @Deprecated
    @Dependencies(value={"getNumber", "getNumberType"})
    @XmlElement(name="voice", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<String> getVoices() {
        if (FilterByVersion.LEGACY_METADATA.accept()) {
            return new LegacyTelephones(this.getOwner(), UnsupportedCodeList.VOICE);
        }
        return null;
    }

    @Deprecated
    public void setVoices(Collection<? extends String> newValues) {
        ((LegacyTelephones)this.getVoices()).setValues(newValues);
    }

    @Deprecated
    @Dependencies(value={"getNumber", "getNumberType"})
    @XmlElement(name="facsimile", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<String> getFacsimiles() {
        if (FilterByVersion.LEGACY_METADATA.accept()) {
            return new LegacyTelephones(this.getOwner(), UnsupportedCodeList.FACSIMILE);
        }
        return null;
    }

    @Deprecated
    public void setFacsimiles(Collection<? extends String> newValues) {
        ((LegacyTelephones)this.getFacsimiles()).setValues(newValues);
    }
}

