/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Plan;
import org.opengis.metadata.acquisition.Priority;
import org.opengis.metadata.acquisition.RequestedDate;
import org.opengis.metadata.acquisition.Requirement;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;

@XmlType(name="MI_Requirement_Type", propOrder={"citation", "identifier", "requestors", "recipients", "priority", "requestedDate", "expiryDate", "satisfiedPlans"})
@XmlRootElement(name="MI_Requirement")
public class DefaultRequirement
extends ISOMetadata
implements Requirement {
    private static final long serialVersionUID = -4987984804974769238L;
    private Citation citation;
    private Collection<ResponsibleParty> requestors;
    private Collection<ResponsibleParty> recipients;
    private Priority priority;
    private RequestedDate requestedDate;
    private long expiryDate = Long.MIN_VALUE;
    private Collection<Plan> satisfiedPlans;

    public DefaultRequirement() {
    }

    public DefaultRequirement(Requirement object) {
        super(object);
        if (object != null) {
            this.citation = object.getCitation();
            this.identifiers = this.singleton(object.getIdentifier(), Identifier.class);
            this.requestors = this.copyCollection(object.getRequestors(), ResponsibleParty.class);
            this.recipients = this.copyCollection(object.getRecipients(), ResponsibleParty.class);
            this.priority = object.getPriority();
            this.requestedDate = object.getRequestedDate();
            this.expiryDate = MetadataUtilities.toMilliseconds(object.getExpiryDate());
            this.satisfiedPlans = this.copyCollection(object.getSatisfiedPlans(), Plan.class);
        }
    }

    public static DefaultRequirement castOrCopy(Requirement object) {
        if (object == null || object instanceof DefaultRequirement) {
            return (DefaultRequirement)object;
        }
        return new DefaultRequirement(object);
    }

    @XmlElement(name="citation")
    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation newValue) {
        this.checkWritePermission(this.citation);
        this.citation = newValue;
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    @Override
    public void setIdentifier(Identifier newValue) {
        super.setIdentifier(newValue);
    }

    @XmlElement(name="requestor", required=true)
    public Collection<ResponsibleParty> getRequestors() {
        this.requestors = this.nonNullCollection(this.requestors, ResponsibleParty.class);
        return this.requestors;
    }

    public void setRequestors(Collection<? extends ResponsibleParty> newValues) {
        this.requestors = this.writeCollection(newValues, this.requestors, ResponsibleParty.class);
    }

    @XmlElement(name="recipient", required=true)
    public Collection<ResponsibleParty> getRecipients() {
        this.recipients = this.nonNullCollection(this.recipients, ResponsibleParty.class);
        return this.recipients;
    }

    public void setRecipients(Collection<? extends ResponsibleParty> newValues) {
        this.recipients = this.writeCollection(newValues, this.recipients, ResponsibleParty.class);
    }

    @XmlElement(name="priority", required=true)
    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority newValue) {
        this.checkWritePermission(this.priority);
        this.priority = newValue;
    }

    @XmlElement(name="requestedDate", required=true)
    public RequestedDate getRequestedDate() {
        return this.requestedDate;
    }

    public void setRequestedDate(RequestedDate newValue) {
        this.checkWritePermission(this.requestedDate);
        this.requestedDate = newValue;
    }

    @XmlElement(name="expiryDate", required=true)
    public Date getExpiryDate() {
        return MetadataUtilities.toDate(this.expiryDate);
    }

    public void setExpiryDate(Date newValue) {
        this.checkWritePermission(MetadataUtilities.toDate(this.expiryDate));
        this.expiryDate = MetadataUtilities.toMilliseconds(newValue);
    }

    @XmlElement(name="satisifiedPlan")
    public Collection<Plan> getSatisfiedPlans() {
        this.satisfiedPlans = this.nonNullCollection(this.satisfiedPlans, Plan.class);
        return this.satisfiedPlans;
    }

    public void setSatisfiedPlans(Collection<? extends Plan> newValues) {
        this.satisfiedPlans = this.writeCollection(newValues, this.satisfiedPlans, Plan.class);
    }
}

