/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.IdentifierMapAdapter;
import org.apache.sis.internal.jaxb.ModifiableIdentifierMap;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;

@XmlTransient
public class ISOMetadata
extends ModifiableMetadata
implements IdentifiedObject,
Serializable {
    private static final long serialVersionUID = -4997239501383133209L;
    protected Collection<Identifier> identifiers;

    protected ISOMetadata() {
    }

    protected ISOMetadata(Object object) {
        if (object instanceof IdentifiedObject) {
            if (object instanceof ISOMetadata && Containers.isNullOrEmpty(((ISOMetadata)object).identifiers) && object.getClass().getName().startsWith("org.apache.sis.")) {
                return;
            }
            this.identifiers = this.copyCollection(((IdentifiedObject)object).getIdentifiers(), Identifier.class);
        }
    }

    @Override
    public MetadataStandard getStandard() {
        return MetadataStandard.ISO_19115;
    }

    public Collection<Identifier> getIdentifiers() {
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        return this.identifiers;
    }

    @Override
    public IdentifierMap getIdentifierMap() {
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        if (this.identifiers == null) {
            return IdentifierMapAdapter.EMPTY;
        }
        return super.state() != ModifiableMetadata.State.FINAL ? new ModifiableIdentifierMap(this.identifiers) : new IdentifierMapAdapter(this.identifiers);
    }

    protected Identifier getIdentifier() {
        return NonMarshalledAuthority.getMarshallable(this.identifiers);
    }

    protected void setIdentifier(Identifier newValue) {
        this.checkWritePermission(MetadataUtilities.valueIfDefined(this.identifiers));
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        this.identifiers = this.writeCollection(NonMarshalledAuthority.setMarshallable(this.identifiers, newValue), this.identifiers, Identifier.class);
    }

    @Override
    public boolean transitionTo(ModifiableMetadata.State target) {
        Collection<Identifier> p = this.identifiers;
        boolean changed = super.transitionTo(target);
        if (changed && p != null && p == this.identifiers) {
            this.identifiers = p instanceof Set ? CollectionsExt.unmodifiableOrCopy((Set)p) : (p instanceof List ? CollectionsExt.unmodifiableOrCopy((List)p) : Collections.unmodifiableCollection(p));
        }
        return changed;
    }

    @XmlID
    @XmlAttribute
    @XmlSchemaType(name="ID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String getID() {
        return Containers.isNullOrEmpty(this.identifiers) ? null : MetadataUtilities.getObjectID(this);
    }

    private void setID(String id) {
        MetadataUtilities.setObjectID(this, id);
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String getUUID() {
        return Containers.isNullOrEmpty(this.identifiers) ? null : (String)this.getIdentifierMap().get(IdentifierSpace.UUID);
    }

    private void setUUID(String id) {
        this.getIdentifierMap().put(IdentifierSpace.UUID, id);
    }
}

