/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.DerivedScalar;
import org.apache.sis.measure.ScalarFactory;
import org.apache.sis.measure.ScalarFallback;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class Quantities
extends Static {
    private Quantities() {
    }

    public static Quantity<?> create(double value, String unit) {
        return Quantities.create(value, Units.valueOf(unit));
    }

    public static <Q extends Quantity<Q>> Q create(double value, Unit<Q> unit) {
        ArgumentChecks.ensureNonNull("unit", unit);
        Unit system = unit.getSystemUnit();
        if (system instanceof SystemUnit) {
            Object quantity;
            UnitConverter c = unit.getConverterTo(system);
            ScalarFactory<Q> factory = ((SystemUnit)system).factory;
            if (c.isLinear()) {
                if (factory != null) {
                    return factory.create(value, unit);
                }
                return ScalarFallback.factory(value, unit, ((SystemUnit)system).quantity);
            }
            if (factory != null && (quantity = factory.createDerived(value, unit, system, c)) != null) {
                return quantity;
            }
            return DerivedScalar.Fallback.factory(value, unit, system, c, ((SystemUnit)system).quantity);
        }
        throw new IllegalArgumentException(Errors.format((short)160, unit.getClass()));
    }

    public static <Q extends Quantity<Q>> Q castOrCopy(Quantity<Q> quantity) {
        if (quantity != null) {
            Unit unit = quantity.getUnit();
            Unit system = unit.getSystemUnit();
            if (!(system instanceof SystemUnit)) {
                throw new IllegalArgumentException(Errors.format((short)160, unit.getClass()));
            }
            Class type = ((SystemUnit)system).quantity;
            if (!type.isInstance(quantity)) {
                ScalarFactory factory = ((SystemUnit)system).factory;
                double value = AbstractConverter.doubleValue(quantity.getValue());
                if (factory != null) {
                    return factory.create(value, unit);
                }
                return ScalarFallback.factory(value, unit, type);
            }
        }
        return (Q)quantity;
    }
}

