/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;
import org.apache.sis.math.StatisticsFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.opengis.util.InternationalString;

public class Statistics
implements DoubleConsumer,
LongConsumer,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8495118253884975477L;
    private final InternationalString name;
    private double minimum = Double.NaN;
    private double maximum = Double.NaN;
    private double sum;
    private double squareSum;
    private transient double lowBits;
    private transient double squareLowBits;
    private int count;
    private int countNaN;

    public Statistics(CharSequence name) {
        this.name = name == null || name instanceof InternationalString ? (InternationalString)name : new SimpleInternationalString(name.toString());
    }

    public static Statistics forSeries(CharSequence name, CharSequence ... differenceNames) {
        ArgumentChecks.ensureNonNull("differenceNames", differenceNames);
        Statistics stats = null;
        int i = differenceNames.length;
        while (--i >= -1) {
            CharSequence n = i >= 0 ? differenceNames[i] : name;
            stats = stats == null ? new Statistics(n) : new WithDelta(n, stats);
        }
        return stats;
    }

    public InternationalString name() {
        return this.name;
    }

    public void reset() {
        this.minimum = Double.NaN;
        this.maximum = Double.NaN;
        this.sum = 0.0;
        this.squareSum = 0.0;
        this.lowBits = 0.0;
        this.squareLowBits = 0.0;
        this.count = 0;
        this.countNaN = 0;
    }

    @Override
    public void accept(double sample) {
        if (Double.isFinite(sample)) {
            this.real(sample);
        } else if (Double.isNaN(sample)) {
            ++this.countNaN;
        } else {
            this.real(sample);
            this.sum = sample;
            this.squareSum = Double.POSITIVE_INFINITY;
            this.lowBits = 0.0;
            this.squareLowBits = 0.0;
        }
    }

    private void real(double sample) {
        if (!(this.minimum <= sample)) {
            this.minimum = sample;
        }
        if (!(this.maximum >= sample)) {
            this.maximum = sample;
        }
        double y = sample + this.lowBits;
        this.lowBits = y + (this.sum - (this.sum += y));
        sample *= sample;
        y = sample + this.squareLowBits;
        this.squareLowBits = y + (this.squareSum - (this.squareSum += y));
        ++this.count;
    }

    @Override
    public void accept(long sample) {
        double y = sample;
        this.real(y);
        if ((sample -= (long)y) != 0L) {
            y = (double)sample + this.lowBits;
            this.lowBits = y + (this.sum - (this.sum += y));
        }
    }

    public void combine(Statistics stats) {
        ArgumentChecks.ensureNonNull("stats", stats);
        if (Double.isNaN(this.minimum) || stats.minimum < this.minimum) {
            this.minimum = stats.minimum;
        }
        if (Double.isNaN(this.maximum) || stats.maximum > this.maximum) {
            this.maximum = stats.maximum;
        }
        double y = stats.sum + this.lowBits;
        this.lowBits = y + (this.sum - (this.sum += y)) + stats.lowBits;
        y = stats.squareSum + this.squareLowBits;
        this.squareLowBits = y + (this.squareSum - (this.squareSum += y)) + stats.squareLowBits;
        this.count += stats.count;
        this.countNaN += Math.max(stats.countNaN, 0);
    }

    public void scale(double factor) {
        ArgumentChecks.ensureFinite("factor", factor);
        this.minimum *= factor;
        this.maximum *= factor;
        this.sum *= factor;
        this.lowBits *= factor;
        factor *= factor;
        this.squareSum *= factor;
        this.squareLowBits *= factor;
    }

    void decrementCountNaN() {
        --this.countNaN;
    }

    public int countNaN() {
        return Math.max(this.countNaN, 0);
    }

    public int count() {
        return this.count;
    }

    public double minimum() {
        return this.minimum;
    }

    public double maximum() {
        return this.maximum;
    }

    public double span() {
        return this.maximum - this.minimum;
    }

    public double sum() {
        return this.sum;
    }

    public double mean() {
        return this.sum / (double)this.count;
    }

    public double rms() {
        return Math.sqrt(this.squareSum / (double)this.count);
    }

    public double standardDeviation(boolean allPopulation) {
        return Math.sqrt((this.squareSum - this.sum * this.sum / (double)this.count) / (double)(allPopulation ? this.count : this.count - 1));
    }

    public Statistics differences() {
        return null;
    }

    public String toString() {
        return StatisticsFormat.getInstance().format(this);
    }

    public Statistics clone() {
        try {
            return (Statistics)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.minimum) + 31L * (Double.doubleToLongBits(this.maximum) + 31L * (Double.doubleToLongBits(this.sum) + 31L * Double.doubleToLongBits(this.squareSum)));
        return (int)code ^ (int)(code >>> 32) ^ this.count;
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            Statistics cast = (Statistics)object;
            return this.count == cast.count && this.countNaN == cast.countNaN && Double.doubleToLongBits(this.minimum) == Double.doubleToLongBits(cast.minimum) && Double.doubleToLongBits(this.maximum) == Double.doubleToLongBits(cast.maximum) && Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(cast.sum) && Double.doubleToLongBits(this.squareSum) == Double.doubleToLongBits(cast.squareSum) && Objects.equals(this.name, cast.name);
        }
        return false;
    }

    private static final class WithDelta
    extends Statistics {
        private static final long serialVersionUID = -5149634417399815874L;
        private Statistics delta;
        private double last = Double.NaN;
        private long lastAsLong;

        WithDelta(CharSequence name, Statistics delta) {
            super(name);
            this.delta = delta;
            delta.decrementCountNaN();
        }

        @Override
        public void reset() {
            super.reset();
            this.delta.reset();
            this.delta.decrementCountNaN();
            this.last = Double.NaN;
            this.lastAsLong = 0L;
        }

        @Override
        public void accept(double sample) {
            super.accept(sample);
            this.delta.accept(sample - this.last);
            this.last = sample;
            this.lastAsLong = (long)sample;
        }

        @Override
        public void accept(long sample) {
            super.accept(sample);
            if (this.last == (double)this.lastAsLong) {
                this.delta.accept(sample - this.lastAsLong);
            } else {
                this.delta.accept((double)sample - this.last);
            }
            this.last = sample;
            this.lastAsLong = sample;
        }

        @Override
        public void combine(Statistics stats) throws ClassCastException {
            ArgumentChecks.ensureNonNull("stats", stats);
            this.delta.combine(stats.differences());
            super.combine(stats);
            if (stats instanceof WithDelta) {
                WithDelta toAdd = (WithDelta)stats;
                this.last = toAdd.last;
                this.lastAsLong = toAdd.lastAsLong;
            } else {
                this.last = Double.NaN;
                this.lastAsLong = 0L;
            }
        }

        @Override
        public void scale(double factor) {
            super.scale(factor);
            this.delta.scale(factor);
        }

        @Override
        final void decrementCountNaN() {
            super.decrementCountNaN();
            this.delta.decrementCountNaN();
        }

        @Override
        public Statistics differences() {
            return this.delta;
        }

        @Override
        public Statistics clone() {
            WithDelta copy = (WithDelta)super.clone();
            copy.delta = copy.delta.clone();
            return copy;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.delta.equals(((WithDelta)obj).delta);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 31 * this.delta.hashCode();
        }
    }
}

