/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.util.function.DoubleUnaryOperator;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.ArrayVector;
import org.apache.sis.math.CompoundDirectPositions;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;

public class Line
implements DoubleUnaryOperator,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2185952238314399110L;
    private static final int DIMENSION = 2;
    private double slope;
    private double y0;
    private double x0;

    public Line() {
        this.x0 = Double.NaN;
        this.y0 = Double.NaN;
        this.slope = Double.NaN;
    }

    public Line(double slope, double y0) {
        this.slope = slope;
        this.y0 = y0;
        this.x0 = -y0 / slope;
    }

    public final double slope() {
        return this.slope;
    }

    public final double x0() {
        return this.x0;
    }

    public final double x(double y) {
        return this.x0 + y / this.slope;
    }

    public final double y0() {
        return this.y0;
    }

    public final double y(double x) {
        return this.y0 + x * this.slope;
    }

    @Override
    public double applyAsDouble(double x) {
        return this.y(x);
    }

    public void translate(double dx, double dy) {
        if (this.slope == 0.0 || Double.isInfinite(this.slope)) {
            this.x0 += dx;
            this.y0 += dy;
        } else {
            this.x0 += dx - dy / this.slope;
            this.y0 += dy - this.slope * dx;
        }
    }

    public void setEquation(double slope, double y0) {
        this.slope = slope;
        this.y0 = y0;
        this.x0 = -y0 / slope;
    }

    public void setEquation(Number slope, Number y0) {
        this.setEquation(slope.doubleValue(), y0.doubleValue());
    }

    public void setFromPoints(double x1, double y1, double x2, double y2) {
        this.slope = (y2 - y1) / (x2 - x1);
        this.x0 = x2 - y2 / this.slope;
        this.y0 = y2 - this.slope * x2;
        if (Double.isNaN(this.x0) && this.slope == 0.0) {
            this.x0 = Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(this.y0) && Double.isInfinite(this.slope)) {
            this.y0 = Double.POSITIVE_INFINITY;
        }
    }

    public double fit(double[] x, double[] y) {
        ArgumentChecks.ensureNonNull("x", x);
        ArgumentChecks.ensureNonNull("y", y);
        return this.fit(new ArrayVector.Doubles(x), new ArrayVector.Doubles(y));
    }

    public double fit(Vector x, Vector y) {
        ArgumentChecks.ensureNonNull("x", x);
        ArgumentChecks.ensureNonNull("y", y);
        return this.fit(new CompoundDirectPositions(x, y));
    }

    public double fit(Iterable<? extends DirectPosition> points) {
        ArgumentChecks.ensureNonNull("points", points);
        int i = 0;
        int n = 0;
        DoubleDouble mean_x = new DoubleDouble();
        DoubleDouble mean_y = new DoubleDouble();
        for (DirectPosition directPosition : points) {
            double x;
            int dimension = directPosition.getDimension();
            if (dimension != 2) {
                throw new MismatchedDimensionException(Errors.format((short)81, Strings.toIndexed("points", i), 2, dimension));
            }
            ++i;
            double y = directPosition.getOrdinate(1);
            if (Double.isNaN(y) || Double.isNaN(x = directPosition.getOrdinate(0))) continue;
            mean_x.addKahan(x);
            mean_y.addKahan(y);
            ++n;
        }
        mean_x.divide(n);
        mean_y.divide(n);
        DoubleDouble a = new DoubleDouble();
        DoubleDouble doubleDouble = new DoubleDouble();
        DoubleDouble mean_x2 = new DoubleDouble();
        DoubleDouble mean_y2 = new DoubleDouble();
        DoubleDouble mean_xy = new DoubleDouble();
        for (DirectPosition directPosition : points) {
            double y = directPosition.getOrdinate(1);
            if (Double.isNaN(y) || Double.isNaN(a.value = directPosition.getOrdinate(0))) continue;
            a.error = 0.0;
            a.subtract(mean_x);
            doubleDouble.setFrom(a);
            doubleDouble.multiply(a);
            mean_x2.add(doubleDouble);
            a.multiply(y);
            mean_xy.add(a);
            a.setToProduct(y, y);
            mean_y2.add(a);
        }
        mean_x2.divide(n);
        mean_y2.divide(n);
        mean_xy.divide(n);
        a.setFrom(mean_xy);
        a.divide(mean_x2);
        doubleDouble.setFrom(mean_x);
        doubleDouble.multiply(a);
        doubleDouble.negate();
        doubleDouble.add(mean_y);
        this.setEquation(a, doubleDouble);
        a.setFrom(mean_y);
        a.multiply(mean_y);
        a.negate();
        a.add(mean_y2);
        a.multiply(mean_x2);
        a.sqrt();
        a.inverseDivide(mean_xy);
        return a.doubleValue();
    }

    public Line clone() {
        try {
            return (Line)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            Line that = (Line)object;
            return Numerics.equals(this.slope, that.slope) && Numerics.equals(this.y0, that.y0) && Numerics.equals(this.x0, that.x0);
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(0x1E560FFAA4B32586L ^ Double.doubleToLongBits(this.slope) + 31L * Double.doubleToLongBits(this.y0));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(50);
        if (Double.isInfinite(this.slope)) {
            buffer.append("x = ").append(this.x0);
        } else {
            buffer.append("y = ");
            String separator = "";
            if (this.slope != 0.0) {
                buffer.append(this.slope).append("\u22c5x");
                separator = " + ";
            }
            if (this.y0 != 0.0) {
                buffer.append(separator).append(this.y0);
            }
        }
        return buffer.toString();
    }
}

