/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.resources.Errors;

public final class Fraction
extends Number
implements Comparable<Fraction>,
Serializable {
    private static final long serialVersionUID = -4501644254763471216L;
    private static final WeakHashSet<Fraction> POOL = new WeakHashSet<Fraction>(Fraction.class);
    public final int numerator;
    public final int denominator;
    private static final char[][] UNICODES = new char[][]{{'\u0000', '\u0000', '\u2189'}, {'\u00bd', '\u2153', '\u00bc', '\u2155', '\u2159', '\u2150', '\u215b', '\u2151', '\u2152'}, {'\u2154', '\u0000', '\u2156'}, {'\u00be', '\u2157', '\u0000', '\u0000', '\u215c'}, {'\u2158'}, {'\u215a', '\u0000', '\u215d'}, new char[0], {'\u215e'}};

    public Fraction(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public static Fraction valueOf(double value) {
        if (value == 0.0) {
            return new Fraction(0, MathFunctions.isNegativeZero(value) ? -1 : 1);
        }
        if (!Double.isFinite(value)) {
            return new Fraction(Double.isNaN(value) ? 0 : (value >= 0.0 ? 1 : -1), 0);
        }
        long significand = Numerics.getSignificand(value);
        int exponent = Math.getExponent(value) - 52;
        int shift = Long.numberOfTrailingZeros(significand);
        if ((exponent += shift) > -32 && exponent < Long.numberOfLeadingZeros(significand >>>= shift)) {
            int den;
            if (exponent >= 0) {
                significand <<= exponent;
                den = 1;
            } else {
                den = 1 << -exponent;
            }
            if ((significand & Integer.MIN_VALUE) == 0L) {
                if (value < 0.0) {
                    significand = -significand;
                }
                return new Fraction((int)significand, den);
            }
        } else {
            double toMaximalSignificand = 4.503599627370495E15 / Math.ceil(Math.abs(value));
            if (toMaximalSignificand > 1.0) {
                int base;
                exponent = Numerics.toExp10(Math.getExponent(toMaximalSignificand));
                double factor = DecimalFunctions.pow10(exponent + 1);
                if (factor > toMaximalSignificand) {
                    factor = DecimalFunctions.pow10(exponent);
                }
                assert (factor >= 1.0 && factor <= 4.503599627370495E15) : factor;
                try {
                    Fraction f = Fraction.simplify(null, Math.round(value * factor), Math.round(factor));
                    if (f.doubleValue() == value) {
                        return f;
                    }
                }
                catch (ArithmeticException f) {
                    // empty catch block
                }
                double logMaxFactor = Math.log(toMaximalSignificand);
                for (int i = 1; i < 6542 && !((double)(base = MathFunctions.primeNumberAt(i)) > toMaximalSignificand); ++i) {
                    exponent = (int)(logMaxFactor / Math.log(base));
                    long den = MathFunctions.pow(base, exponent);
                    try {
                        Fraction f = Fraction.simplify(null, Math.round(value * (double)den), den);
                        if (f.doubleValue() != value) continue;
                        return f;
                    }
                    catch (ArithmeticException arithmeticException) {
                        // empty catch block
                    }
                }
            }
        }
        throw new IllegalArgumentException(Errors.format((short)8, value, Fraction.class));
    }

    public Fraction unique() {
        return POOL.unique(this);
    }

    public Fraction simplify() {
        return Fraction.simplify(this, this.numerator, this.denominator);
    }

    private static Fraction simplify(Fraction f, long num, long den) {
        if (num == Long.MIN_VALUE || den == Long.MIN_VALUE) {
            throw new ArithmeticException(Errors.format((short)188, 64));
        }
        if (num == 0L) {
            den = Long.signum(den);
        } else if (den == 0L) {
            num = Long.signum(num);
        } else if (den % num == 0L) {
            if ((den /= num) < 0L) {
                den = -den;
                num = -1L;
            } else {
                num = 1L;
            }
        } else {
            long gcd;
            long a = Math.abs(num);
            long remainder = a % (gcd = Math.abs(den));
            if (remainder == 0L) {
                num /= den;
                den = 1L;
            } else {
                while ((remainder = (a = gcd) % (gcd = remainder)) != 0L) {
                }
                num /= gcd;
                if ((den /= gcd) < 0L) {
                    num = -num;
                    den = -den;
                }
            }
        }
        return f != null && num == (long)f.numerator && den == (long)f.denominator ? f : new Fraction(Math.toIntExact(num), Math.toIntExact(den));
    }

    public Fraction negate() {
        int n = this.numerator;
        int d = this.denominator;
        if (n != 0) {
            n = Math.negateExact(n);
        } else if (d != 0) {
            d = Math.negateExact(d);
        } else {
            return this;
        }
        return new Fraction(n, d);
    }

    public Fraction add(Fraction other) {
        long td = this.denominator;
        long od = other.denominator;
        return Fraction.simplify(this, Math.addExact(od * (long)this.numerator, td * (long)other.numerator), od * td);
    }

    public Fraction subtract(Fraction other) {
        long td = this.denominator;
        long od = other.denominator;
        return Fraction.simplify(this, Math.subtractExact(od * (long)this.numerator, td * (long)other.numerator), od * td);
    }

    public Fraction multiply(Fraction other) {
        return Fraction.simplify(this, (long)this.numerator * (long)other.numerator, (long)this.denominator * (long)other.denominator);
    }

    public Fraction divide(Fraction other) {
        return Fraction.simplify(this, (long)this.numerator * (long)other.denominator, (long)this.denominator * (long)other.numerator);
    }

    public int round() {
        int d;
        if (this.denominator == Integer.MIN_VALUE) {
            if (this.numerator < -1073741824) {
                return 1;
            }
            if (this.numerator > 0x40000000) {
                return -1;
            }
            return 0;
        }
        int n = this.numerator / this.denominator;
        int r = this.numerator % this.denominator;
        if (r != 0 && ((r = Math.abs(r << 1)) > (d = Math.abs(this.denominator)) || r == d && (n & 1) != 0)) {
            n = (this.numerator ^ this.denominator) >= 0 ? ++n : --n;
        }
        return n;
    }

    public int floor() {
        int n = this.numerator / this.denominator;
        if ((this.numerator ^ this.denominator) < 0 && this.numerator % this.denominator != 0) {
            --n;
        }
        return n;
    }

    public int ceil() {
        int n = this.numerator / this.denominator;
        if ((this.numerator ^ this.denominator) >= 0 && this.numerator % this.denominator != 0) {
            ++n;
        }
        return n;
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public int intValue() {
        return this.numerator / this.denominator;
    }

    @Override
    public short shortValue() {
        int n = this.intValue();
        if ((n & 0xFFFF0000) == 0) {
            return (short)n;
        }
        throw new ArithmeticException(Errors.format((short)188, 16));
    }

    @Override
    public byte byteValue() {
        int n = this.intValue();
        if ((n & 0xFFFFFF00) == 0) {
            return (byte)n;
        }
        throw new ArithmeticException(Errors.format((short)188, 8));
    }

    public int signum() {
        if (this.numerator == 0) {
            return 0;
        }
        return (this.numerator ^ this.denominator) >> 30 | 1;
    }

    @Override
    public int compareTo(Fraction other) {
        return Long.signum((long)this.numerator * (long)other.denominator - (long)other.numerator * (long)this.denominator);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Fraction) {
            Fraction that = (Fraction)other;
            return this.numerator == that.numerator && this.denominator == that.denominator;
        }
        return false;
    }

    public int hashCode() {
        return this.numerator + 31 * this.denominator ^ 0xA9A52E90;
    }

    public String toString() {
        switch (this.denominator) {
            case 0: {
                if (this.numerator == 0) break;
                return this.numerator >= 0 ? "\u221e" : "\u2212\u221e";
            }
            case 1: {
                return String.valueOf(this.numerator);
            }
            default: {
                char c;
                char[] r;
                int d;
                if (this.numerator < 0 || this.numerator >= UNICODES.length || (d = this.denominator - this.numerator - 1) < 0 || d >= (r = UNICODES[this.numerator]).length || (c = r[d]) == '\u0000') break;
                return String.valueOf(c);
            }
        }
        return "" + this.numerator + '\u2044' + this.denominator;
    }

    public Fraction(String s) throws NumberFormatException {
        char c;
        ArgumentChecks.ensureNonEmpty("s", s);
        int length = s.length();
        if (length == 1 && (c = s.charAt(0)) >= '\u0080') {
            for (int j = 0; j < UNICODES.length; ++j) {
                char[] unicodes = UNICODES[j];
                for (int i = 0; i < unicodes.length; ++i) {
                    if (unicodes[i] != c) continue;
                    this.numerator = j;
                    this.denominator = j + i + 1;
                    return;
                }
            }
            if (c == '\u221e') {
                this.numerator = 1;
                this.denominator = 0;
                return;
            }
        }
        if (s.equals("\u2212\u221e") || s.equals("-\u221e")) {
            this.numerator = -1;
            this.denominator = 0;
            return;
        }
        for (int i = 0; i < length; ++i) {
            switch (s.charAt(i)) {
                case '/': 
                case '\u00f7': 
                case '\u2044': 
                case '\u2215': {
                    this.numerator = Integer.parseInt(s.substring(0, i));
                    this.denominator = Integer.parseInt(s.substring(i + 1));
                    return;
                }
            }
        }
        this.numerator = Integer.parseInt(s);
        this.denominator = 1;
    }
}

