/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.io.wkt.GeodeticObjectParser;
import org.apache.sis.io.wkt.KeywordCase;
import org.apache.sis.io.wkt.KeywordStyle;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.UnparsableObjectException;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.Factory;

public class WKTFormat
extends CompoundFormat<Object> {
    private static final long serialVersionUID = -2909110214650709560L;
    public static final int SINGLE_LINE = -1;
    private Symbols symbols;
    private Colors colors;
    private Convention convention = Convention.DEFAULT;
    private Citation authority;
    private KeywordCase keywordCase;
    private KeywordStyle keywordStyle;
    private Transliterator transliterator;
    private byte indentation;
    private int listSizeLimit;
    private Map<String, Element> fragments;
    private transient Map<Object, Object> sharedValues;
    private transient Formatter formatter;
    private transient AbstractParser parser;
    private transient ReferencingFactoryContainer factories;
    private transient Warnings warnings;

    public WKTFormat(Locale locale, TimeZone timezone) {
        super(locale, timezone);
        this.symbols = Symbols.getDefault();
        this.keywordCase = KeywordCase.DEFAULT;
        this.keywordStyle = KeywordStyle.DEFAULT;
        this.indentation = (byte)2;
        this.listSizeLimit = Integer.MAX_VALUE;
    }

    private Map<String, Element> fragments() {
        if (this.fragments == null) {
            this.fragments = new TreeMap<String, Element>();
        }
        return this.fragments;
    }

    private ReferencingFactoryContainer factories() {
        if (this.factories == null) {
            this.factories = new ReferencingFactoryContainer();
        }
        return this.factories;
    }

    @Override
    public Locale getLocale(Locale.Category category) {
        if (category == Locale.Category.FORMAT) {
            return this.symbols.getLocale();
        }
        return super.getLocale(category);
    }

    public Symbols getSymbols() {
        return this.symbols;
    }

    public void setSymbols(Symbols symbols) {
        ArgumentChecks.ensureNonNull("symbols", symbols);
        if (!symbols.equals(this.symbols)) {
            this.symbols = symbols.immutable();
            this.formatter = null;
            this.parser = null;
        }
    }

    public Transliterator getTransliterator() {
        Transliterator result = this.transliterator;
        if (result == null) {
            result = this.convention == Convention.INTERNAL ? Transliterator.IDENTITY : Transliterator.DEFAULT;
        }
        return result;
    }

    public void setTransliterator(Transliterator transliterator) {
        if (this.transliterator != transliterator) {
            this.transliterator = transliterator;
            this.updateFormatter(this.formatter);
            this.parser = null;
        }
    }

    public KeywordCase getKeywordCase() {
        return this.keywordCase;
    }

    public void setKeywordCase(KeywordCase keywordCase) {
        ArgumentChecks.ensureNonNull("keywordCase", (Object)keywordCase);
        this.keywordCase = keywordCase;
        this.updateFormatter(this.formatter);
    }

    public KeywordStyle getKeywordStyle() {
        return this.keywordStyle;
    }

    public void setKeywordStyle(KeywordStyle keywordStyle) {
        ArgumentChecks.ensureNonNull("keywordStyle", (Object)keywordStyle);
        this.keywordStyle = keywordStyle;
        this.updateFormatter(this.formatter);
    }

    public Colors getColors() {
        return this.colors;
    }

    public void setColors(Colors colors) {
        if (colors != null) {
            colors = colors.immutable();
        }
        this.colors = colors;
        this.updateFormatter(this.formatter);
    }

    public Convention getConvention() {
        return this.convention;
    }

    public void setConvention(Convention convention) {
        ArgumentChecks.ensureNonNull("convention", (Object)convention);
        if (this.convention != convention) {
            this.convention = convention;
            this.updateFormatter(this.formatter);
            this.parser = null;
        }
    }

    public Citation getNameAuthority() {
        Citation result = this.authority;
        if (result == null) {
            result = this.convention.getNameAuthority();
        }
        return result;
    }

    public void setNameAuthority(Citation authority) {
        this.authority = authority;
        this.updateFormatter(this.formatter);
    }

    private void updateFormatter(Formatter formatter) {
        if (formatter != null) {
            byte longKeywords;
            byte toUpperCase;
            switch (this.keywordCase) {
                case LOWER_CASE: {
                    toUpperCase = -1;
                    break;
                }
                case UPPER_CASE: {
                    toUpperCase = 1;
                    break;
                }
                case CAMEL_CASE: {
                    toUpperCase = 0;
                    break;
                }
                default: {
                    toUpperCase = this.convention.toUpperCase ? (byte)1 : 0;
                }
            }
            switch (this.keywordStyle) {
                case SHORT: {
                    longKeywords = -1;
                    break;
                }
                case LONG: {
                    longKeywords = 1;
                    break;
                }
                default: {
                    longKeywords = this.convention.majorVersion() == 1 ? (byte)-1 : 0;
                }
            }
            formatter.configure(this.convention, this.authority, this.colors, toUpperCase, longKeywords, this.indentation, this.listSizeLimit);
            if (this.transliterator != null) {
                formatter.transliterator = this.transliterator;
            }
        }
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int indentation) {
        ArgumentChecks.ensureBetween("indentation", -1, 127, indentation);
        this.indentation = (byte)indentation;
        this.updateFormatter(this.formatter);
    }

    public int getMaximumListElements() {
        return this.listSizeLimit;
    }

    public void setMaximumListElements(int limit) {
        ArgumentChecks.ensureStrictlyPositive("limit", limit);
        this.listSizeLimit = limit;
        this.updateFormatter(this.formatter);
    }

    private void ensureValidFactoryType(Class<?> type) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("type", type);
        if (type != CRSFactory.class && type != CSFactory.class && type != DatumFactory.class && type != MathTransformFactory.class && type != CoordinateOperationFactory.class) {
            throw new IllegalArgumentException(Errors.getResources(this.getLocale()).getString((short)45, "type", type));
        }
    }

    public <T extends Factory> T getFactory(Class<T> type) {
        this.ensureValidFactoryType(type);
        return this.factories().getFactory(type);
    }

    public <T extends Factory> void setFactory(Class<T> type, T factory) {
        this.ensureValidFactoryType(type);
        if (this.factories().setFactory(type, factory)) {
            this.parser = null;
        }
    }

    @Override
    public final Class<Object> getValueType() {
        return Object.class;
    }

    public Set<String> getFragmentNames() {
        return this.fragments().keySet();
    }

    public void addFragment(String name, String wkt) throws IllegalArgumentException, ParseException {
        ArgumentChecks.ensureNonEmpty("wkt", wkt);
        ArgumentChecks.ensureNonEmpty("name", name);
        int error = 112;
        if (CharSequences.isUnicodeIdentifier(name)) {
            if (this.sharedValues == null) {
                this.sharedValues = new HashMap<Object, Object>();
            }
            ParsePosition pos = new ParsePosition(0);
            Element element = new Element(this.parser(), wkt, pos, this.sharedValues);
            int index = CharSequences.skipLeadingWhitespaces(wkt, pos.getIndex(), wkt.length());
            if (index < wkt.length()) {
                throw new UnparsableObjectException(this.getLocale(), 135, new Object[]{name + " = " + element.keyword + "[\u2026]", CharSequences.token(wkt, index)}, index);
            }
            if (this.fragments.putIfAbsent(name, element) == null) {
                return;
            }
            error = 27;
        }
        throw new IllegalArgumentException(Errors.getResources(this.getLocale()).getString((short)error, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parse(CharSequence wkt, ParsePosition pos) throws ParseException {
        this.warnings = null;
        this.sharedValues = null;
        ArgumentChecks.ensureNonEmpty("wkt", wkt);
        ArgumentChecks.ensureNonNull("pos", pos);
        AbstractParser parser = this.parser();
        Object object = null;
        try {
            Object object2 = object = parser.parseObject(wkt.toString(), pos);
            this.warnings = parser.getAndClearWarnings(object);
            return object2;
        }
        catch (Throwable throwable) {
            this.warnings = parser.getAndClearWarnings(object);
            throw throwable;
        }
    }

    private AbstractParser parser() {
        AbstractParser parser = this.parser;
        if (parser == null) {
            this.parser = parser = new Parser(this.symbols, this.fragments(), (NumberFormat)this.getFormat(Number.class), (DateFormat)this.getFormat(Date.class), (UnitFormat)this.getFormat(Unit.class), this.convention, this.transliterator != null ? this.transliterator : Transliterator.DEFAULT, this.getLocale(), this.factories());
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(Object object, Appendable toAppendTo) throws IOException {
        this.warnings = null;
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("toAppendTo", toAppendTo);
        StringBuffer buffer = toAppendTo instanceof StringBuffer ? (StringBuffer)toAppendTo : new StringBuffer(500);
        Formatter formatter = this.formatter;
        if (formatter == null) {
            formatter = new Formatter(this.getLocale(), this.symbols, (NumberFormat)this.getFormat(Number.class), (DateFormat)this.getFormat(Date.class), (UnitFormat)this.getFormat(Unit.class));
            this.updateFormatter(formatter);
            this.formatter = formatter;
        }
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            boolean valid;
            try {
                formatter.setBuffer(buffer);
                valid = formatter.appendElement(object) || formatter.appendValue(object);
            }
            finally {
                this.warnings = formatter.getWarnings();
                formatter.setBuffer(null);
                formatter.clear();
            }
            if (this.warnings != null) {
                this.warnings.setRoot(object);
            }
            if (!valid) {
                throw new ClassCastException(Errors.getResources(this.getLocale()).getString((short)42, "object", object.getClass()));
            }
            if (buffer != toAppendTo) {
                toAppendTo.append(buffer);
            }
        }
    }

    @Override
    protected Format createFormat(Class<?> valueType) {
        if (valueType == Number.class) {
            return this.symbols.createNumberFormat();
        }
        if (valueType == Date.class) {
            return new StandardDateFormat(this.symbols.getLocale(), this.getTimeZone());
        }
        Format format = super.createFormat(valueType);
        if (format instanceof UnitFormat) {
            ((UnitFormat)format).setStyle(UnitFormat.Style.NAME);
        }
        return format;
    }

    public Warnings getWarnings() {
        Warnings w = this.warnings;
        if (w != null) {
            w.publish();
        }
        return w;
    }

    @Override
    public WKTFormat clone() {
        WKTFormat clone = (WKTFormat)super.clone();
        clone.formatter = null;
        clone.parser = null;
        clone.warnings = null;
        return clone;
    }

    private static final class Parser
    extends GeodeticObjectParser {
        Parser(Symbols symbols, Map<String, Element> fragments, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, Convention convention, Transliterator transliterator, Locale errorLocale, ReferencingFactoryContainer factories) {
            super(symbols, fragments, numberFormat, dateFormat, unitFormat, convention, transliterator, errorLocale, factories);
        }

        @Override
        String getPublicFacade() {
            return WKTFormat.class.getName();
        }

        @Override
        String getFacadeMethod() {
            return "parse";
        }
    }
}

