/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Date;
import org.apache.sis.internal.geoapi.temporal.Instant;
import org.apache.sis.internal.geoapi.temporal.Period;
import org.apache.sis.internal.geoapi.temporal.TemporalFactory;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.opengis.temporal.TemporalPrimitive;

public final class TemporalUtilities
extends Static {
    public static final boolean REPORT_MISSING_MODULE = false;

    private TemporalUtilities() {
    }

    public static TemporalFactory getTemporalFactory() throws UnsupportedOperationException {
        TemporalFactory factory = DefaultFactories.forClass(TemporalFactory.class);
        if (factory != null) {
            return factory;
        }
        throw new UnsupportedOperationException(Errors.format((short)87, "sis-temporal"));
    }

    private static Instant createInstant(TemporalFactory factory, Date date) {
        return factory.createInstant(date);
    }

    public static Instant createInstant(Date time) throws UnsupportedOperationException {
        return time != null ? TemporalUtilities.createInstant(TemporalUtilities.getTemporalFactory(), time) : null;
    }

    public static Period createPeriod(Date begin, Date end) throws UnsupportedOperationException {
        TemporalFactory factory = TemporalUtilities.getTemporalFactory();
        return factory.createPeriod(TemporalUtilities.createInstant(factory, begin), TemporalUtilities.createInstant(factory, end));
    }

    public static Date getDate(TemporalPrimitive time) {
        Instant instant;
        if (time instanceof Instant) {
            instant = (Instant)time;
        } else if (time instanceof Period) {
            instant = ((Period)time).getEnding();
            if (instant == null) {
                instant = ((Period)time).getBeginning();
            }
        } else {
            return null;
        }
        return instant.getDate();
    }

    public static Date toDate(java.time.Instant instant) {
        return instant != null ? Date.from(instant) : null;
    }
}

