/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.io.InvalidClassException;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;

public final class FinalFieldSetter<T>
implements PrivilegedAction<FinalFieldSetter<T>> {
    private final Field field;
    private Field second;

    public FinalFieldSetter(Class<T> classe, String field) throws NoSuchFieldException {
        assert (classe.getName().startsWith("org.apache.sis.")) : classe;
        this.field = classe.getDeclaredField(field);
    }

    public FinalFieldSetter(Class<T> classe, String field, String second) throws NoSuchFieldException {
        this(classe, field);
        this.second = classe.getDeclaredField(second);
    }

    @Override
    public FinalFieldSetter<T> run() throws SecurityException {
        this.field.setAccessible(true);
        if (this.second != null) {
            this.second.setAccessible(true);
        }
        return this;
    }

    public final void set(T instance, Object value) throws IllegalAccessException {
        this.field.set(instance, value);
    }

    public final void set(T instance, Object value, Object more) throws IllegalAccessException {
        this.field.set(instance, value);
        this.second.set(instance, more);
    }

    public static InvalidClassException readFailure(ReflectiveOperationException cause) {
        return (InvalidClassException)new InvalidClassException(cause.getLocalizedMessage()).initCause(cause);
    }

    public static RuntimeException cloneFailure(ReflectiveOperationException cause) {
        return new RuntimeException(cause);
    }
}

