/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.internal.util.AbstractMapEntry;
import org.apache.sis.internal.util.Bag;
import org.apache.sis.internal.util.SetOfUnknownSize;
import org.apache.sis.io.TableAppender;
import org.apache.sis.util.resources.Errors;

public abstract class AbstractMap<K, V>
implements Map<K, V> {
    protected AbstractMap() {
    }

    @Override
    public int size() {
        int count = 0;
        EntryIterator<K, V> it = this.entryIterator();
        while (it.next() && ++count != Integer.MAX_VALUE) {
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return !this.entryIterator().next();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        EntryIterator<K, V> it = this.entryIterator();
        if (it != null) {
            while (it.next()) {
                if (!it.getValue().equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        Object value = this.get(key);
        return value != null ? value : defaultValue;
    }

    static String message(boolean add) {
        return Errors.format(add ? (short)162 : 153, add ? "add" : Map.class);
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(AbstractMap.message(false));
    }

    @Override
    public V remove(Object key) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(AbstractMap.message(false));
    }

    @Override
    public V put(K key, V value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(AbstractMap.message(false));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) throws UnsupportedOperationException {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected boolean addKey(K key) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(AbstractMap.message(true));
    }

    protected boolean addValue(V value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(AbstractMap.message(true));
    }

    @Override
    public Set<K> keySet() {
        return new SetOfUnknownSize<K>(){

            @Override
            public void clear() {
                AbstractMap.this.clear();
            }

            @Override
            public boolean isEmpty() {
                return AbstractMap.this.isEmpty();
            }

            @Override
            public int size() {
                return AbstractMap.this.size();
            }

            @Override
            public boolean contains(Object e) {
                return AbstractMap.this.containsKey(e);
            }

            @Override
            public boolean remove(Object e) {
                return AbstractMap.this.remove(e) != null;
            }

            @Override
            public boolean add(K e) {
                return AbstractMap.this.addKey(e);
            }

            @Override
            public Iterator<K> iterator() {
                EntryIterator it = AbstractMap.this.entryIterator();
                return it != null ? new Keys(it) : Collections.emptyIterator();
            }

            @Override
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Set)) {
                    return false;
                }
                Set that = (Set)object;
                EntryIterator it = AbstractMap.this.entryIterator();
                if (it == null) {
                    return that.isEmpty();
                }
                int size = 0;
                while (it.next()) {
                    if (!that.contains(it.getKey())) {
                        return false;
                    }
                    ++size;
                }
                return size == that.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new Bag<V>(){

            @Override
            public void clear() {
                AbstractMap.this.clear();
            }

            @Override
            public boolean isEmpty() {
                return AbstractMap.this.isEmpty();
            }

            @Override
            public int size() {
                return AbstractMap.this.size();
            }

            @Override
            public boolean contains(Object e) {
                return AbstractMap.this.containsValue(e);
            }

            @Override
            public boolean add(V e) {
                return AbstractMap.this.addValue(e);
            }

            @Override
            public Iterator<V> iterator() {
                EntryIterator it = AbstractMap.this.entryIterator();
                return it != null ? new Values(it) : Collections.emptyIterator();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SetOfUnknownSize<Map.Entry<K, V>>(){

            @Override
            public void clear() {
                AbstractMap.this.clear();
            }

            @Override
            public boolean isEmpty() {
                return AbstractMap.this.isEmpty();
            }

            @Override
            public int size() {
                return AbstractMap.this.size();
            }

            @Override
            public boolean contains(Object e) {
                Map.Entry entry;
                Object value;
                if (e instanceof Map.Entry && (value = AbstractMap.this.get((entry = (Map.Entry)e).getKey())) != null) {
                    return value.equals(entry.getValue());
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                EntryIterator it = AbstractMap.this.entryIterator();
                return it != null ? new Entries(it) : Collections.emptyIterator();
            }

            @Override
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Set)) {
                    return false;
                }
                Set that = (Set)object;
                EntryIterator it = AbstractMap.this.entryIterator();
                if (it == null) {
                    return that.isEmpty();
                }
                int size = 0;
                while (it.next()) {
                    if (!that.contains(it.getEntry())) {
                        return false;
                    }
                    ++size;
                }
                return size == that.size();
            }
        };
    }

    protected abstract EntryIterator<K, V> entryIterator();

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map that = (Map)object;
        EntryIterator<K, V> it = this.entryIterator();
        if (it == null) {
            return that.isEmpty();
        }
        int size = 0;
        while (it.next()) {
            if (!it.getValue().equals(that.get(it.getKey()))) {
                return false;
            }
            ++size;
        }
        return size == that.size();
    }

    @Override
    public int hashCode() {
        int code = 0;
        EntryIterator<K, V> it = this.entryIterator();
        if (it != null) {
            while (it.next()) {
                code += Objects.hashCode(it.getKey()) ^ Objects.hashCode(it.getValue());
            }
        }
        return code;
    }

    public String toString() {
        TableAppender buffer = new TableAppender(" = ");
        buffer.setMultiLinesCells(true);
        EntryIterator<K, V> it = this.entryIterator();
        if (it != null) {
            while (it.next()) {
                buffer.append(String.valueOf(it.getKey()));
                buffer.nextColumn();
                buffer.append(AbstractMapEntry.firstLine(it.getValue()));
                buffer.nextLine();
            }
        }
        return buffer.toString();
    }

    private static final class Entries<K, V>
    extends Iter<K, V>
    implements Iterator<Map.Entry<K, V>> {
        Entries(EntryIterator<K, V> it) {
            super(it);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.entry().getEntry();
        }
    }

    private static final class Values<K, V>
    extends Iter<K, V>
    implements Iterator<V> {
        Values(EntryIterator<K, V> it) {
            super(it);
        }

        @Override
        public V next() {
            return this.entry().getValue();
        }
    }

    private static final class Keys<K, V>
    extends Iter<K, V>
    implements Iterator<K> {
        Keys(EntryIterator<K, V> it) {
            super(it);
        }

        @Override
        public K next() {
            return this.entry().getKey();
        }
    }

    private static abstract class Iter<K, V> {
        private final EntryIterator<K, V> iterator;
        private byte hasNext;
        private static final byte TRUE = 1;
        private static final byte FALSE = 2;
        private static final byte AFTER_NEXT = 3;

        Iter(EntryIterator<K, V> iterator) {
            this.iterator = iterator;
        }

        public final boolean hasNext() {
            switch (this.hasNext) {
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            boolean c = this.iterator.next();
            this.hasNext = (byte)(c ? 1 : 2);
            return c;
        }

        final EntryIterator<K, V> entry() {
            if (this.hasNext()) {
                this.hasNext = (byte)3;
                return this.iterator;
            }
            throw new NoSuchElementException();
        }

        public final void remove() {
            if (this.hasNext != 3) {
                throw new IllegalStateException();
            }
            this.hasNext = 0;
            this.iterator.remove();
        }
    }

    protected static class IteratorAdapter<K, V>
    extends EntryIterator<K, V> {
        protected Iterator<Map.Entry<K, V>> it;
        protected Map.Entry<K, V> entry;
        protected V value;

        public IteratorAdapter(Map<K, V> map) {
            this.it = map.entrySet().iterator();
        }

        @Override
        protected boolean next() {
            do {
                if (!this.it.hasNext()) {
                    return false;
                }
                this.entry = this.it.next();
                this.value = this.entry.getValue();
            } while (this.value == null);
            return true;
        }

        @Override
        protected K getKey() {
            return this.entry.getKey();
        }

        @Override
        protected V getValue() {
            return this.value;
        }
    }

    protected final class KeyIterator
    extends EntryIterator<K, V> {
        private final K[] keys;
        private int index = -1;
        private V value;

        @SafeVarargs
        public KeyIterator(K ... keys) {
            this.keys = keys;
        }

        @Override
        protected boolean next() {
            while (++this.index < this.keys.length) {
                this.value = AbstractMap.this.get(this.keys[this.index]);
                if (this.value == null) continue;
                return true;
            }
            return false;
        }

        @Override
        protected K getKey() {
            return this.keys[this.index];
        }

        @Override
        protected V getValue() {
            return this.value;
        }
    }

    protected static abstract class EntryIterator<K, V> {
        protected EntryIterator() {
        }

        protected abstract boolean next();

        protected abstract K getKey();

        protected abstract V getValue();

        protected Map.Entry<K, V> getEntry() {
            return new AbstractMap.SimpleImmutableEntry<K, V>(this.getKey(), this.getValue());
        }

        protected void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException(AbstractMap.message(false));
        }
    }
}

