/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import org.apache.sis.internal.system.DaemonThread;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;

final class Threads
extends Static {
    static final ThreadGroup SIS;
    static final ThreadGroup DAEMONS;
    static DaemonThread lastCreatedDaemon;

    private Threads() {
    }

    static synchronized void shutdown(long stopWaitingAt) throws InterruptedException {
        DaemonThread.killAll(lastCreatedDaemon, stopWaitingAt);
    }

    static {
        ThreadGroup parent = Thread.currentThread().getThreadGroup();
        try {
            ThreadGroup candidate;
            while ((candidate = parent.getParent()) != null) {
                parent = candidate;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SIS = new ThreadGroup(parent, "Apache SIS");
        DAEMONS = new ThreadGroup(SIS, "Daemons"){

            @Override
            public void uncaughtException(Thread thread, Throwable exception) {
                Logging.severeException(Logging.getLogger("org.apache.sis.system"), thread.getClass(), "run", exception);
            }
        };
    }
}

