/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;

public abstract class OptionalDependency
extends SystemListener {
    private final String dependency;

    protected OptionalDependency(String module, String dependency) {
        super(module);
        this.dependency = dependency;
        SystemListener.add(this);
    }

    @Override
    protected void classpathChanged() {
        SystemListener.remove(this);
    }

    protected static <T extends OptionalDependency> T getInstance(Class<T> type, String module, String dependency, String implementation) {
        try {
            return (T)((OptionalDependency)type.cast(Class.forName(implementation).newInstance()));
        }
        catch (ClassNotFoundException exception) {
            LogRecord record = Messages.getResources(null).getLogRecord(Level.CONFIG, (short)27, dependency);
            record.setLoggerName(module);
            Logging.log(type, "getInstance", record);
            return null;
        }
        catch (ReflectiveOperationException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    protected final UnsupportedOperationException moduleNotFound() {
        return new UnsupportedOperationException(Errors.format((short)87, this.dependency));
    }
}

