/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import org.apache.sis.internal.system.DaemonThread;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.internal.system.Threads;
import org.apache.sis.util.logging.Logging;

public final class DelayedExecutor
extends DaemonThread {
    private static final BlockingQueue<DelayedRunnable> QUEUE = new DelayQueue<DelayedRunnable>();

    public static void schedule(DelayedRunnable task) {
        QUEUE.add(task);
    }

    private DelayedExecutor(DaemonThread lastCreatedDaemon) {
        super("DelayedExecutor", lastCreatedDaemon);
        this.setPriority(6);
    }

    @Override
    public final void run() {
        BlockingQueue<DelayedRunnable> queue;
        while ((queue = QUEUE) != null) {
            try {
                DelayedRunnable task = queue.take();
                if (task != null) {
                    task.run();
                    continue;
                }
            }
            catch (InterruptedException task) {
            }
            catch (Throwable exception) {
                Logging.unexpectedException(Logging.getLogger("org.apache.sis.system"), this.getClass(), "run", exception);
            }
            if (!this.isKillRequested()) continue;
            queue.clear();
            break;
        }
    }

    @Override
    protected boolean isStalled() {
        DelayedRunnable waiting = (DelayedRunnable)QUEUE.peek();
        if (waiting != null && waiting.getDelay(TimeUnit.NANOSECONDS) <= 0L) {
            try {
                for (int i = 0; i < 50 && this.isAlive(); ++i) {
                    Thread.sleep(100L);
                    if (QUEUE.peek() == waiting) continue;
                    return false;
                }
                return true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<Threads> clazz = Threads.class;
        synchronized (Threads.class) {
            DelayedExecutor thread = new DelayedExecutor(Threads.lastCreatedDaemon);
            Threads.lastCreatedDaemon = thread;
            thread.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

