/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml.stream;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sis.internal.xml.StreamWriterDelegate;

final class NamespaceEraser
extends StreamWriterDelegate {
    private final String defaultNamespace;

    NamespaceEraser(XMLStreamWriter out, String namespaceURI) {
        super(out);
        this.defaultNamespace = namespaceURI;
    }

    private boolean isDefault(String ns) {
        return this.defaultNamespace.equals(ns);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        if (this.isDefault(namespaceURI)) {
            this.out.writeStartElement(localName);
        } else {
            this.out.writeStartElement(namespaceURI, localName);
        }
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (this.isDefault(namespaceURI)) {
            this.out.writeStartElement(localName);
        } else {
            this.out.writeStartElement(prefix, localName, namespaceURI);
        }
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        if (this.isDefault(namespaceURI)) {
            this.out.writeEmptyElement(localName);
        } else {
            this.out.writeEmptyElement(namespaceURI, localName);
        }
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (this.isDefault(namespaceURI)) {
            this.out.writeEmptyElement(localName);
        } else {
            this.out.writeEmptyElement(prefix, localName, namespaceURI);
        }
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.isDefault(namespaceURI)) {
            this.out.writeAttribute(localName, value);
        } else {
            this.out.writeAttribute(prefix, namespaceURI, localName, value);
        }
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.isDefault(namespaceURI)) {
            this.out.writeAttribute(localName, value);
        } else {
            this.out.writeAttribute(namespaceURI, localName, value);
        }
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (!this.isDefault(namespaceURI)) {
            if (prefix.equals("")) {
                throw new XMLStreamException(namespaceURI);
            }
            this.out.writeNamespace(prefix, namespaceURI);
        }
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        if (!this.isDefault(namespaceURI)) {
            throw new XMLStreamException(namespaceURI);
        }
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        if (!this.isDefault(uri)) {
            throw new XMLStreamException(uri);
        }
    }
}

