/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.query;

import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.storage.AbstractFeatureSet;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.query.SimpleQuery;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.event.StoreListeners;

final class FeatureSubset
extends AbstractFeatureSet {
    private final FeatureSet source;
    private final SimpleQuery query;
    private DefaultFeatureType resultType;

    FeatureSubset(FeatureSet source, SimpleQuery query) {
        super(source instanceof StoreListeners ? (StoreListeners)((Object)source) : null);
        this.source = source;
        this.query = query;
    }

    @Override
    public synchronized DefaultFeatureType getType() throws DataStoreException {
        if (this.resultType == null) {
            DefaultFeatureType type = this.source.getType();
            try {
                this.resultType = this.query.expectedType(type);
            }
            catch (IllegalArgumentException e) {
                throw new DataStoreContentException(Resources.forLocale(this.getLocale()).getString((short)55, type.getName()), e);
            }
        }
        return this.resultType;
    }

    @Override
    public Stream<AbstractFeature> features(boolean parallel) throws DataStoreException {
        long limit;
        Stream<AbstractFeature> stream = this.source.features(parallel);
        long offset = this.query.getOffset();
        if (offset > 0L) {
            stream = stream.skip(offset);
        }
        if ((limit = this.query.getLimit()) >= 0L) {
            stream = stream.limit(limit);
        }
        return stream;
    }
}

