/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import org.apache.sis.internal.storage.io.InputStreamAdapter;
import org.apache.sis.io.InvalidSeekException;

public final class RewindableLineReader
extends LineNumberReader {
    public static final int BUFFER_SIZE = 8192;
    private InputStreamAdapter input;
    private final Charset encoding;

    public RewindableLineReader(InputStream input, Charset encoding) throws IOException {
        super(encoding != null ? new InputStreamReader(input, encoding) : new InputStreamReader(input), 8192);
        if (input instanceof InputStreamAdapter) {
            this.input = (InputStreamAdapter)input;
        }
        this.encoding = encoding;
        super.mark(8192);
        this.lock = input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RewindableLineReader rewind() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.reset();
                return this;
            }
            catch (IOException e1) {
                InputStreamAdapter stream = this.input;
                if (stream == null) {
                    throw new InvalidSeekException();
                }
                this.input = null;
                assert (Thread.holdsLock(stream));
                try {
                    stream.keepOpen = true;
                    super.close();
                }
                finally {
                    stream.keepOpen = false;
                }
                try {
                    stream.input.seek(0L);
                }
                catch (IOException e2) {
                    e2.addSuppressed(e1);
                    throw e2;
                }
                return new RewindableLineReader(stream, this.encoding);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.input = null;
            super.close();
        }
    }
}

