/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.TableAppender;

public final class Region {
    final int[] targetSize;
    final long startAt;
    final long[] skips;

    public Region(long[] size, long[] regionLower, long[] regionUpper, int[] subsamplings) {
        int dimension = size.length;
        this.targetSize = new int[dimension];
        this.skips = new long[dimension + 1];
        long position = 0L;
        long stride = 1L;
        long skip = 0L;
        int i = 0;
        while (i < dimension) {
            int step = subsamplings[i];
            long lower = regionLower[i];
            long count = Numerics.ceilDiv(regionUpper[i] - lower, (long)step);
            long upper = lower + ((count - 1L) * (long)step + 1L);
            long span = size[i];
            assert (count > 0L && lower >= 0L && upper > lower && upper <= span) : i;
            this.targetSize[i] = Math.toIntExact(count);
            position = Math.addExact(position, Math.multiplyExact(stride, lower));
            skip = Math.addExact(skip, Math.multiplyExact(stride, span - (upper - lower)));
            this.skips[i] = Math.addExact(this.skips[i], Math.multiplyExact(stride, step - 1));
            stride = Math.multiplyExact(stride, span);
            this.skips[++i] = skip;
        }
        this.startAt = position;
    }

    public void increaseStride(int dimension, long skip) {
        this.skips[dimension] = Math.addExact(this.skips[dimension], skip);
    }

    public final int getDimension() {
        return this.targetSize.length;
    }

    final int contiguousDataDimension() {
        int i;
        int dimension = this.skips.length - 1;
        for (i = 0; i < dimension && this.skips[i] == 0L; ++i) {
        }
        return i;
    }

    final int targetLength(int dimension) {
        long length = 1L;
        for (int i = 0; i < dimension; ++i) {
            length *= (long)this.targetSize[i];
        }
        return Math.toIntExact(length);
    }

    public String toString() {
        TableAppender table = new TableAppender(" ");
        table.setCellAlignment((byte)1);
        table.append("size").nextColumn();
        table.append("skip").nextLine();
        for (int i = 0; i < this.targetSize.length; ++i) {
            table.append(String.valueOf(this.targetSize[i])).nextColumn();
            table.append(String.valueOf(this.skips[i])).nextLine();
        }
        return table.toString();
    }
}

