/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.internal.storage.io.ChannelDataInput;

public class ChannelImageInputStream
extends ChannelDataInput
implements ImageInputStream {
    public ChannelImageInputStream(String filename, ReadableByteChannel channel, ByteBuffer buffer, boolean filled) throws IOException {
        super(filename, channel, buffer, filled);
    }

    public ChannelImageInputStream(ChannelDataInput input) throws IOException {
        super(input.filename, input.channel, input.buffer, true);
    }

    @Override
    public final void setByteOrder(ByteOrder byteOrder) {
        this.buffer.order(byteOrder);
    }

    @Override
    public final ByteOrder getByteOrder() {
        return this.buffer.order();
    }

    @Override
    public final long length() throws IOException {
        if (this.channel instanceof SeekableByteChannel) {
            return ((SeekableByteChannel)this.channel).size();
        }
        return -1L;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public final String readUTF() throws IOException {
        ByteOrder oldOrder = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            String string = DataInputStream.readUTF(this);
            return string;
        }
        finally {
            this.buffer.order(oldOrder);
        }
    }

    @Override
    public final String readLine() throws IOException {
        int c = this.read();
        if (c < 0) {
            return null;
        }
        StringBuilder line = new StringBuilder();
        line.append((char)c);
        block4: while ((c = this.read()) >= 0) {
            switch (c) {
                case 13: {
                    c = this.read();
                    if (c < 0 || c == 10) break block4;
                    this.pushBack();
                    break block4;
                }
                case 10: {
                    break block4;
                }
                default: {
                    line.append((char)c);
                    continue block4;
                }
            }
        }
        return line.toString();
    }

    @Override
    public final int read() throws IOException {
        return this.hasRemaining() ? Byte.toUnsignedInt(this.buffer.get()) : -1;
    }

    @Override
    public final int read(byte[] dest) throws IOException {
        return this.read(dest, 0, dest.length);
    }

    @Override
    public final int read(byte[] dest, int offset, int length) throws IOException {
        if (!this.hasRemaining()) {
            return -1;
        }
        int requested = length;
        while (length != 0 && this.hasRemaining()) {
            int n = Math.min(this.buffer.remaining(), length);
            this.buffer.get(dest, offset, n);
            offset += n;
            length -= n;
        }
        return requested - length;
    }

    @Override
    public final void readBytes(IIOByteBuffer dest, int length) throws IOException {
        byte[] data = new byte[length];
        length = this.read(data);
        dest.setData(data);
        dest.setOffset(0);
        dest.setLength(length);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        if (!this.hasRemaining()) {
            return 0;
        }
        int r = this.buffer.remaining();
        if (n >= r) {
            n = r;
        }
        this.buffer.position(this.buffer.position() + n);
        return n;
    }

    @Override
    public final long skipBytes(long n) throws IOException {
        return this.skipBytes((int)Math.min(n, Integer.MAX_VALUE));
    }

    @Override
    public final void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    @Override
    public final boolean isCached() {
        return this.isCachedMemory();
    }

    @Override
    public final boolean isCachedMemory() {
        return false;
    }

    @Override
    public final boolean isCachedFile() {
        return false;
    }

    @Override
    public final void close() throws IOException {
        this.channel.close();
    }
}

