/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ForwardOnlyStorageException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public abstract class ChannelFactory {
    private static final Set<StandardOpenOption> ILLEGAL_OPTIONS = EnumSet.of(StandardOpenOption.APPEND, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE);

    ChannelFactory() {
    }

    public static ChannelFactory prepare(Object storage, String encoding, boolean allowWriteOnly, OpenOption ... options) throws IOException {
        Path path;
        Serializable file;
        Set<StandardOpenOption> optionSet;
        block23: {
            if (options == null || options.length == 0) {
                optionSet = Collections.singleton(StandardOpenOption.READ);
            } else {
                optionSet = new HashSet<OpenOption>(Arrays.asList(options));
                optionSet.add(StandardOpenOption.READ);
                if (!allowWriteOnly && optionSet.removeAll(ILLEGAL_OPTIONS)) {
                    throw new IllegalArgumentException(Errors.format((short)45, "options", Arrays.toString(options)));
                }
            }
            if (storage instanceof ReadableByteChannel || allowWriteOnly && storage instanceof WritableByteChannel) {
                return new Stream((Channel)storage);
            }
            if (storage instanceof InputStream) {
                return new Stream(Channels.newChannel((InputStream)storage));
            }
            if (allowWriteOnly && storage instanceof OutputStream) {
                return new Stream(Channels.newChannel((OutputStream)storage));
            }
            if (storage instanceof URL) {
                try {
                    storage = IOUtilities.toPath((URL)storage, encoding);
                }
                catch (IOException e) {
                    ChannelFactory.recoverableException(e);
                }
            } else if (storage instanceof URI) {
                URI uri = (URI)storage;
                if (!uri.isAbsolute()) {
                    throw new IOException(Resources.format((short)11, uri));
                }
                try {
                    storage = Paths.get(uri);
                }
                catch (IllegalArgumentException | FileSystemNotFoundException e) {
                    try {
                        storage = uri.toURL();
                    }
                    catch (MalformedURLException ioe) {
                        ioe.addSuppressed(e);
                        throw ioe;
                    }
                    ChannelFactory.recoverableException(e);
                }
            } else {
                if (storage instanceof CharSequence) {
                    storage = IOUtilities.toFileOrURL(storage.toString(), encoding);
                }
                if (storage instanceof File) {
                    file = (File)storage;
                    try {
                        storage = ((File)file).toPath();
                    }
                    catch (InvalidPathException e) {
                        if (!((File)file).isFile()) break block23;
                        return new Fallback((File)file, e);
                    }
                }
            }
        }
        if (storage instanceof URL) {
            file = (URL)storage;
            return new ChannelFactory((URL)file){
                final /* synthetic */ URL val$file;
                {
                    this.val$file = uRL;
                }

                @Override
                public ReadableByteChannel readable(String filename, StoreListeners listeners) throws IOException {
                    return Channels.newChannel(this.val$file.openStream());
                }

                @Override
                public WritableByteChannel writable(String filename, StoreListeners listeners) throws IOException {
                    return Channels.newChannel(this.val$file.openConnection().getOutputStream());
                }
            };
        }
        if (storage instanceof Path && !Files.isDirectory(path = (Path)storage, new LinkOption[0])) {
            return new ChannelFactory(){

                @Override
                public ReadableByteChannel readable(String filename, StoreListeners listeners) throws IOException {
                    return Files.newByteChannel(path, optionSet, new FileAttribute[0]);
                }

                @Override
                public WritableByteChannel writable(String filename, StoreListeners listeners) throws IOException {
                    return Files.newByteChannel(path, optionSet, new FileAttribute[0]);
                }
            };
        }
        return null;
    }

    public boolean isCoupled() {
        return false;
    }

    public boolean canOpen() {
        return true;
    }

    public InputStream inputStream(String filename, StoreListeners listeners) throws DataStoreException, IOException {
        return Channels.newInputStream(this.readable(filename, listeners));
    }

    public OutputStream outputStream(String filename, StoreListeners listeners) throws DataStoreException, IOException {
        return Channels.newOutputStream(this.writable(filename, listeners));
    }

    public abstract ReadableByteChannel readable(String var1, StoreListeners var2) throws DataStoreException, IOException;

    public abstract WritableByteChannel writable(String var1, StoreListeners var2) throws DataStoreException, IOException;

    private static void recoverableException(Exception warning) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.storage"), ChannelFactory.class, "prepare", warning);
    }

    private static final class Fallback
    extends ChannelFactory {
        private final File file;
        private InvalidPathException cause;

        Fallback(File file, InvalidPathException cause) {
            this.file = file;
            this.cause = cause;
        }

        @Override
        public FileInputStream inputStream(String filename, StoreListeners listeners) throws IOException {
            FileInputStream in;
            try {
                in = new FileInputStream(this.file);
            }
            catch (IOException ioe) {
                if (this.cause != null) {
                    ioe.addSuppressed(this.cause);
                    this.cause = null;
                }
                throw ioe;
            }
            this.warning("inputStream", listeners);
            return in;
        }

        @Override
        public FileOutputStream outputStream(String filename, StoreListeners listeners) throws IOException {
            FileOutputStream out;
            try {
                out = new FileOutputStream(this.file);
            }
            catch (IOException ioe) {
                if (this.cause != null) {
                    ioe.addSuppressed(this.cause);
                    this.cause = null;
                }
                throw ioe;
            }
            this.warning("outputStream", listeners);
            return out;
        }

        private void warning(String method, StoreListeners listeners) {
            if (this.cause != null) {
                LogRecord record = new LogRecord(Level.WARNING, this.cause.toString());
                record.setLoggerName("org.apache.sis.storage");
                record.setSourceMethodName(method);
                record.setSourceClassName(ChannelFactory.class.getName());
                record.setThrown(this.cause);
                this.cause = null;
                if (listeners != null) {
                    listeners.warning(record);
                } else {
                    Logging.getLogger("org.apache.sis.storage").log(record);
                }
            }
        }

        @Override
        public ReadableByteChannel readable(String filename, StoreListeners listeners) throws IOException {
            return this.inputStream(filename, listeners).getChannel();
        }

        @Override
        public WritableByteChannel writable(String filename, StoreListeners listeners) throws IOException {
            return this.outputStream(filename, listeners).getChannel();
        }
    }

    private static final class Stream
    extends ChannelFactory {
        private Channel channel;

        Stream(Channel input) {
            this.channel = input;
        }

        @Override
        public boolean isCoupled() {
            return true;
        }

        @Override
        public boolean canOpen() {
            return this.channel != null;
        }

        @Override
        public ReadableByteChannel readable(String filename, StoreListeners listeners) throws DataStoreException, IOException {
            Channel in = this.channel;
            if (in instanceof ReadableByteChannel) {
                this.channel = null;
                return (ReadableByteChannel)in;
            }
            String message = Resources.format(in != null ? (short)25 : 18, filename);
            if (in != null) {
                throw new IOException(message);
            }
            throw new ForwardOnlyStorageException(message);
        }

        @Override
        public WritableByteChannel writable(String filename, StoreListeners listeners) throws DataStoreException, IOException {
            Channel out = this.channel;
            if (out instanceof WritableByteChannel) {
                this.channel = null;
                return (WritableByteChannel)out;
            }
            String message = Resources.format(out != null ? (short)26 : 21, filename);
            if (out != null) {
                throw new IOException(message);
            }
            throw new ForwardOnlyStorageException(message);
        }
    }
}

