/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.nio.channels.Channel;
import java.nio.channels.SeekableByteChannel;
import org.apache.sis.internal.storage.io.Markable;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public abstract class ChannelData
implements Markable {
    private static final int BIT_OFFSET_SIZE = 3;
    public final String filename;
    public final ByteBuffer buffer;
    public final long channelOffset;
    long bufferOffset;
    private long bitPosition;
    private Mark mark;

    ChannelData(String filename, Channel channel, ByteBuffer buffer) throws IOException {
        this.filename = filename;
        this.buffer = buffer;
        this.channelOffset = channel instanceof SeekableByteChannel ? ((SeekableByteChannel)channel).position() : 0L;
    }

    public final int getBitOffset() {
        long position = this.bufferOffset + (long)this.buffer.position();
        if (this.bitPosition >>> 3 != position) {
            this.bitPosition = position << 3;
        }
        return (int)(this.bitPosition & 7L);
    }

    public final void setBitOffset(int bitOffset) {
        ArgumentChecks.ensureBetween("bitOffset", 0, 7, bitOffset);
        long position = this.bufferOffset + (long)this.buffer.position();
        this.bitPosition = position << 3 | (long)bitOffset;
    }

    final void clearBitOffset() {
        this.bitPosition = 0L;
    }

    @Override
    public long getStreamPosition() {
        return this.bufferOffset + (long)this.buffer.position();
    }

    public final void setStreamPosition(long position) {
        this.bufferOffset = position - (long)this.buffer.position();
        this.clearBitOffset();
        this.mark = null;
    }

    public final long getFlushedPosition() {
        return this.bufferOffset;
    }

    public final void flushBefore(long position) throws IOException {
        long currentPosition = this.getStreamPosition();
        if (position < this.bufferOffset || position > currentPosition) {
            throw new IndexOutOfBoundsException(Errors.format((short)166, "position", this.bufferOffset, currentPosition, position));
        }
        int n = (int)(position - this.bufferOffset);
        int p = this.buffer.position() - n;
        int r = this.buffer.limit() - n;
        this.flushAndSetPosition(n);
        this.buffer.compact().position(p).limit(r);
        Mark lastValid = null;
        Mark m = this.mark;
        while (m != null) {
            if (m.position >= position) {
                lastValid = m;
            }
            m = m.next;
        }
        if (lastValid != null) {
            lastValid.next = null;
        } else {
            this.mark = null;
        }
    }

    void flushAndSetPosition(int position) throws IOException {
        this.buffer.position(position);
        this.bufferOffset += (long)position;
    }

    public abstract void seek(long var1) throws IOException;

    @Override
    public final void mark() {
        this.mark = new Mark(this.getStreamPosition(), (byte)this.getBitOffset(), this.mark);
    }

    @Override
    public final void reset() throws IOException {
        Mark m = this.mark;
        if (m == null) {
            throw new InvalidMarkException();
        }
        this.mark = m.next;
        this.seek(m.position);
        this.setBitOffset(m.bitOffset);
    }

    protected void onEmptyTransfer() throws IOException {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder().append(this.getClass().getSimpleName()).append("[\u201c").append(this.filename).append('\u201d');
        if (this.buffer != null) {
            b.append(" at ").append(this.getStreamPosition());
        }
        return b.append(']').toString();
    }

    private static final class Mark {
        final long position;
        final byte bitOffset;
        Mark next;

        Mark(long position, byte bitOffset, Mark next) {
            this.position = position;
            this.bitOffset = bitOffset;
            this.next = next;
        }
    }
}

