/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.builder.AttributeRole;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.storage.FeatureCatalogBuilder;
import org.apache.sis.internal.storage.gpx.GroupAsPolylineOperation;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.FeatureNaming;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.gps.Fix;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.metadata.acquisition.GeometryType;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;
import org.opengis.util.ScopedName;

final class Types {
    final DefaultFeatureType parent;
    final DefaultFeatureType wayPoint;
    final DefaultFeatureType route;
    final DefaultFeatureType track;
    final DefaultFeatureType trackSegment;
    final Collection<ContentInformation> metadata;
    @Deprecated
    final FeatureNaming<DefaultFeatureType> names;
    final Geometries<?> geometries;
    static final Types DEFAULT;

    Types(NameFactory factory, Locale locale, GeometryLibrary library) throws FactoryException, IllegalNameException {
        this.geometries = Geometries.implementation(library);
        HashMap<String, InternationalString[]> resources = new HashMap<String, InternationalString[]>();
        ScopedName geomName = AttributeConvention.GEOMETRY_PROPERTY;
        Map<String, ScopedName> geomInfo = Collections.singletonMap("name", geomName);
        Map<String, ScopedName> envpInfo = Collections.singletonMap("name", AttributeConvention.ENVELOPE_PROPERTY);
        FeatureTypeBuilder builder = new FeatureTypeBuilder(factory, library, locale);
        builder.setNameSpace("gpx").setName((CharSequence)"GPXEntity").setAbstract(true);
        builder.addAttribute(Integer.class).setName((GenericName)AttributeConvention.IDENTIFIER_PROPERTY);
        this.parent = builder.build();
        builder.clear().setSuperTypes(this.parent).setNameSpace("gpx").setName((CharSequence)"WayPoint");
        ((AttributeTypeBuilder)builder.addAttribute(GeometryType.POINT).setName((GenericName)geomName)).setCRS((CoordinateReferenceSystem)CommonCRS.WGS84.normalizedGeographic()).addRole(AttributeRole.DEFAULT_GEOMETRY);
        builder.setDefaultMultiplicity(0, 1);
        builder.addAttribute(Double.class).setName((CharSequence)"ele");
        builder.addAttribute(Temporal.class).setName((CharSequence)"time");
        builder.addAttribute(Double.class).setName((CharSequence)"magvar");
        builder.addAttribute(Double.class).setName((CharSequence)"geoidheight");
        builder.addAttribute(String.class).setName((CharSequence)"name");
        builder.addAttribute(String.class).setName((CharSequence)"cmt");
        builder.addAttribute(String.class).setName((CharSequence)"desc");
        builder.addAttribute(String.class).setName((CharSequence)"src");
        ((AttributeTypeBuilder)builder.addAttribute(OnlineResource.class).setName((CharSequence)"link")).setMaximumOccurs(Integer.MAX_VALUE);
        builder.addAttribute(String.class).setName((CharSequence)"sym");
        builder.addAttribute(String.class).setName((CharSequence)"type");
        builder.addAttribute(Fix.class).setName((CharSequence)"fix");
        builder.addAttribute(Integer.class).setName((CharSequence)"sat");
        builder.addAttribute(Double.class).setName((CharSequence)"hdop");
        builder.addAttribute(Double.class).setName((CharSequence)"vdop");
        builder.addAttribute(Double.class).setName((CharSequence)"pdop");
        builder.addAttribute(Double.class).setName((CharSequence)"ageofdgpsdata");
        builder.addAttribute(Integer.class).setName((CharSequence)"dgpsid");
        this.wayPoint = Types.create(builder, resources);
        DefaultAttributeType<?> groupResult = GroupAsPolylineOperation.getResult(this.geometries);
        GroupAsPolylineOperation groupOp = new GroupAsPolylineOperation(geomInfo, "rtept", groupResult);
        builder.clear().setSuperTypes(this.parent).setNameSpace("gpx").setName((CharSequence)"Route");
        builder.addProperty(groupOp);
        builder.addProperty(FeatureOperations.envelope(envpInfo, null, groupOp));
        builder.setDefaultMultiplicity(0, 1);
        builder.addProperty(this.wayPoint.getProperty("name"));
        builder.addProperty(this.wayPoint.getProperty("cmt"));
        builder.addProperty(this.wayPoint.getProperty("desc"));
        builder.addProperty(this.wayPoint.getProperty("src"));
        builder.addProperty(this.wayPoint.getProperty("link"));
        builder.addAttribute(Integer.class).setName((CharSequence)"number");
        builder.addProperty(this.wayPoint.getProperty("type"));
        builder.addAssociation(this.wayPoint).setName((CharSequence)"rtept").setMaximumOccurs(Integer.MAX_VALUE);
        this.route = Types.create(builder, resources);
        groupOp = new GroupAsPolylineOperation(geomInfo, "trkpt", groupResult);
        builder.clear().setSuperTypes(this.parent).setNameSpace("gpx").setName((CharSequence)"TrackSegment");
        builder.addProperty(groupOp);
        builder.addProperty(FeatureOperations.envelope(envpInfo, null, groupOp));
        builder.setDefaultMultiplicity(0, 1);
        builder.addAssociation(this.wayPoint).setName((CharSequence)"trkpt").setMaximumOccurs(Integer.MAX_VALUE);
        this.trackSegment = Types.create(builder, resources);
        groupOp = new GroupAsPolylineOperation(geomInfo, "trkseg", groupResult);
        builder.clear().setSuperTypes(this.parent).setNameSpace("gpx").setName((CharSequence)"Track");
        builder.addProperty(groupOp);
        builder.addProperty(FeatureOperations.envelope(envpInfo, null, groupOp));
        builder.setDefaultMultiplicity(0, 1);
        builder.addProperty(this.route.getProperty("name"));
        builder.addProperty(this.route.getProperty("cmt"));
        builder.addProperty(this.route.getProperty("desc"));
        builder.addProperty(this.route.getProperty("src"));
        builder.addProperty(this.route.getProperty("link"));
        builder.addProperty(this.route.getProperty("number"));
        builder.addProperty(this.route.getProperty("type"));
        builder.addAssociation(this.trackSegment).setName((CharSequence)"trkseg").setMaximumOccurs(Integer.MAX_VALUE);
        this.track = Types.create(builder, resources);
        FeatureCatalogBuilder fc = new FeatureCatalogBuilder(null);
        fc.define(this.route);
        fc.define(this.track);
        fc.define(this.wayPoint);
        this.metadata = fc.build(true).getContentInfo();
        this.names = fc.features;
    }

    /*
     * Exception decompiling
     */
    private static DefaultFeatureType create(FeatureTypeBuilder builder, Map<String, InternationalString[]> previous) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        try {
            DEFAULT = new Types(DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class), null, null);
        }
        catch (IllegalNameException | FactoryException e) {
            throw new AssertionError((Object)e);
        }
    }
}

