/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.io.EOFException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.internal.storage.gpx.Bounds;
import org.apache.sis.internal.storage.gpx.Link;
import org.apache.sis.internal.storage.gpx.Metadata;
import org.apache.sis.internal.storage.gpx.Person;
import org.apache.sis.internal.storage.gpx.Store;
import org.apache.sis.internal.storage.gpx.StoreProvider;
import org.apache.sis.internal.storage.gpx.Types;
import org.apache.sis.internal.storage.xml.stream.StaxStreamReader;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.gps.Fix;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.BackingStoreException;

final class Reader
extends StaxStreamReader {
    private String namespace;
    private Metadata metadata;
    private int wayPointId;
    private int routeId;
    private int trackId;

    public Reader(Store owner) throws Exception {
        super(owner);
    }

    private static boolean isGPX(String ns) {
        return ns == null || ns.startsWith("http://www.topografix.com/GPX/");
    }

    private boolean isGPX() {
        String ns = this.reader.getNamespaceURI();
        return Objects.equals(this.namespace, ns) || Reader.isGPX(ns);
    }

    private boolean isEndGPX() {
        assert (this.reader.isEndElement());
        return "gpx".equals(this.reader.getLocalName()) && Objects.equals(this.namespace, this.reader.getNamespaceURI());
    }

    /*
     * Enabled aggressive block sorting
     */
    public Version initialize(boolean readMetadata) throws DataStoreException, XMLStreamException, JAXBException, URISyntaxException, EOFException {
        this.moveToRootElement(Reader::isGPX, "gpx");
        this.namespace = this.reader.getNamespaceURI();
        String ver = this.reader.getAttributeValue(null, "version");
        Version version = null;
        if (ver != null) {
            version = new Version(ver);
            if (version.compareTo(StoreProvider.V1_0, 2) < 0 || version.compareTo(StoreProvider.V1_1, 2) > 0) {
                throw new DataStoreContentException(this.errors().getString((short)159, this.owner.getFormatName(), version));
            }
        } else if (this.namespace != null) {
            switch (this.namespace) {
                case "http://www.topografix.com/GPX/1/0": {
                    version = StoreProvider.V1_0;
                    break;
                }
                case "http://www.topografix.com/GPX/1/1": {
                    version = StoreProvider.V1_1;
                    break;
                }
            }
        }
        block54: while (this.reader.hasNext()) {
            switch (this.next()) {
                case 1: {
                    if (!this.isGPX()) break;
                    String name = this.reader.getLocalName();
                    if (readMetadata) {
                        switch (name) {
                            case "metadata": {
                                this.metadata = this.unmarshal(Metadata.class);
                                break;
                            }
                            case "name": {
                                this.metadata().name = this.getElementText();
                                break;
                            }
                            case "desc": {
                                this.metadata().description = this.getElementText();
                                break;
                            }
                            case "author": {
                                this.author().name = this.getElementText();
                                break;
                            }
                            case "email": {
                                this.author().email = this.getElementText();
                                break;
                            }
                            case "url": {
                                this.link().uri = this.getElementAsURI();
                                break;
                            }
                            case "urlname": {
                                this.link().text = this.getElementText();
                                break;
                            }
                            case "time": {
                                this.metadata().time = this.getElementAsDate();
                                break;
                            }
                            case "keywords": {
                                this.metadata().keywords = this.getElementAsList();
                                break;
                            }
                            case "bounds": {
                                this.metadata().bounds = this.unmarshal(Bounds.class);
                                break;
                            }
                            case "wpt": 
                            case "trk": 
                            case "rte": {
                                break block54;
                            }
                            case "gpx": {
                                throw new DataStoreContentException(this.nestedElement("gpx"));
                            }
                        }
                        break;
                    }
                    switch (name) {
                        case "metadata": {
                            this.skipUntilEnd(this.reader.getName());
                            break;
                        }
                        case "wpt": 
                        case "trk": 
                        case "rte": {
                            break block54;
                        }
                        case "gpx": {
                            throw new DataStoreContentException(this.nestedElement("gpx"));
                        }
                    }
                    break;
                }
                case 2: {
                    if (this.isEndGPX()) break block54;
                }
            }
        }
        if (readMetadata) {
            this.metadata().store = (Store)this.owner;
        }
        return version;
    }

    private Metadata metadata() {
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        return this.metadata;
    }

    private Person author() {
        Metadata metadata = this.metadata();
        if (metadata.author == null) {
            metadata.author = new Person();
        }
        return metadata.author;
    }

    private Link link() {
        Link first;
        Metadata metadata = this.metadata();
        List<Link> links = metadata.links;
        if (links == null) {
            metadata.links = links = new ArrayList<Link>();
        }
        if (links.isEmpty()) {
            first = new Link();
            links.add(first);
        } else {
            first = links.get(0);
        }
        return first;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean tryAdvance(Consumer<? super AbstractFeature> action) throws BackingStoreException {
        try {
            return this.parse(action, false);
        }
        catch (Exception e) {
            throw new BackingStoreException(this.canNotParseFile(), e);
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super AbstractFeature> action) throws BackingStoreException {
        try {
            this.parse(action, true);
        }
        catch (Exception e) {
            throw new BackingStoreException(this.canNotParseFile(), e);
        }
    }

    private boolean parse(Consumer<? super AbstractFeature> action, boolean all) throws Exception {
        int type = this.reader.getEventType();
        while (true) {
            block0 : switch (type) {
                case 1: {
                    AbstractFeature f;
                    switch (this.isGPX() ? this.reader.getLocalName() : "") {
                        case "wpt": {
                            f = this.parseWayPoint(++this.wayPointId);
                            break;
                        }
                        case "rte": {
                            f = this.parseRoute(++this.routeId);
                            break;
                        }
                        case "trk": {
                            f = this.parseTrack(++this.trackId);
                            break;
                        }
                        case "gpx": {
                            throw new DataStoreContentException(this.nestedElement("gpx"));
                        }
                        default: {
                            this.skipUntilEnd(this.reader.getName());
                            break block0;
                        }
                    }
                    action.accept(f);
                    if (all) break;
                    this.reader.next();
                    return true;
                }
                case 2: {
                    if (!this.isEndGPX()) break;
                }
                case 8: {
                    return false;
                }
            }
            type = this.reader.next();
        }
    }

    private AbstractFeature parseWayPoint(int index) throws Exception {
        assert (this.reader.isStartElement());
        String tagName = this.reader.getLocalName();
        String lat = this.reader.getAttributeValue(null, "lat");
        String lon = this.reader.getAttributeValue(null, "lon");
        if (lat == null || lon == null) {
            throw new DataStoreContentException(this.errors().getString((short)76, lat == null ? "lat" : "lon", tagName));
        }
        Types types = ((Store)this.owner).types;
        AbstractFeature feature = types.wayPoint.newInstance();
        feature.setPropertyValue("sis:identifier", index);
        feature.setPropertyValue("sis:geometry", types.geometries.createPoint(Reader.parseDouble(lon), Reader.parseDouble(lat)));
        List<Link> links = null;
        while (true) {
            block0 : switch (this.next()) {
                case 1: {
                    Object value;
                    String name = this.reader.getLocalName();
                    switch (this.isGPX() ? name : "") {
                        case "name": 
                        case "cmt": 
                        case "desc": 
                        case "src": 
                        case "sym": 
                        case "type": {
                            value = this.getElementText();
                            break;
                        }
                        case "time": {
                            value = this.getElementAsTemporal();
                            break;
                        }
                        case "magvar": 
                        case "geoidheight": 
                        case "ageofdgpsdata": 
                        case "hdop": 
                        case "pdop": 
                        case "vdop": 
                        case "ele": {
                            value = this.getElementAsDouble();
                            break;
                        }
                        case "sat": 
                        case "dgpsid": {
                            value = this.getElementAsInteger();
                            break;
                        }
                        case "fix": {
                            value = Fix.fromGPX(this.getElementText());
                            break;
                        }
                        case "link": {
                            links = Metadata.addIfNonNull(links, this.unmarshal(Link.class));
                            break block0;
                        }
                        case "url": {
                            links = Metadata.addIfNonNull(links, Link.valueOf(this.getElementAsURI()));
                            break block0;
                        }
                        default: {
                            if (!name.equals(tagName)) break block0;
                            throw new DataStoreContentException(this.nestedElement(name));
                        }
                    }
                    feature.setPropertyValue(name, value);
                    break;
                }
                case 2: {
                    if (!tagName.equals(this.reader.getLocalName()) || !this.isGPX()) break;
                    if (links != null) {
                        feature.setPropertyValue("link", links);
                    }
                    return feature;
                }
                case 8: {
                    throw new EOFException(this.endOfFile());
                }
            }
        }
    }

    private AbstractFeature parseRoute(int index) throws Exception {
        assert (this.reader.isStartElement() && "rte".equals(this.reader.getLocalName()));
        AbstractFeature feature = ((Store)this.owner).types.route.newInstance();
        feature.setPropertyValue("sis:identifier", index);
        ArrayList<AbstractFeature> wayPoints = null;
        List<Link> links = null;
        while (true) {
            block0 : switch (this.next()) {
                case 1: {
                    Object value;
                    String name = this.reader.getLocalName();
                    switch (this.isGPX() ? name : "") {
                        default: {
                            break block0;
                        }
                        case "name": 
                        case "cmt": 
                        case "desc": 
                        case "src": 
                        case "type": {
                            value = this.getElementText();
                            break;
                        }
                        case "number": {
                            value = this.getElementAsInteger();
                            break;
                        }
                        case "link": {
                            links = Metadata.addIfNonNull(links, this.unmarshal(Link.class));
                            break block0;
                        }
                        case "url": {
                            links = Metadata.addIfNonNull(links, Link.valueOf(this.getElementAsURI()));
                            break block0;
                        }
                        case "rte": {
                            throw new DataStoreContentException(this.nestedElement(name));
                        }
                        case "rtept": {
                            if (wayPoints == null) {
                                wayPoints = new ArrayList<AbstractFeature>(8);
                            }
                            wayPoints.add(this.parseWayPoint(wayPoints.size() + 1));
                            break block0;
                        }
                    }
                    feature.setPropertyValue(name, value);
                    break;
                }
                case 2: {
                    if (!"rte".equals(this.reader.getLocalName()) || !this.isGPX()) break;
                    if (wayPoints != null) {
                        feature.setPropertyValue("rtept", wayPoints);
                    }
                    if (links != null) {
                        feature.setPropertyValue("link", links);
                    }
                    return feature;
                }
                case 8: {
                    throw new EOFException(this.endOfFile());
                }
            }
        }
    }

    private AbstractFeature parseTrackSegment(int index) throws Exception {
        assert (this.reader.isStartElement() && "trkseg".equals(this.reader.getLocalName()));
        AbstractFeature feature = ((Store)this.owner).types.trackSegment.newInstance();
        feature.setPropertyValue("sis:identifier", index);
        ArrayList<AbstractFeature> wayPoints = null;
        while (true) {
            block0 : switch (this.reader.next()) {
                case 1: {
                    String name = this.reader.getLocalName();
                    switch (this.isGPX() ? name : "") {
                        default: {
                            break block0;
                        }
                        case "trkpt": {
                            if (wayPoints == null) {
                                wayPoints = new ArrayList<AbstractFeature>(8);
                            }
                            wayPoints.add(this.parseWayPoint(wayPoints.size() + 1));
                            break block0;
                        }
                        case "trkseg": {
                            throw new DataStoreContentException(this.nestedElement(name));
                        }
                    }
                }
                case 2: {
                    if (!"trkseg".equals(this.reader.getLocalName()) || !this.isGPX()) break;
                    if (wayPoints != null) {
                        feature.setPropertyValue("trkpt", wayPoints);
                    }
                    return feature;
                }
                case 8: {
                    throw new EOFException(this.endOfFile());
                }
            }
        }
    }

    private AbstractFeature parseTrack(int index) throws Exception {
        assert (this.reader.isStartElement() && "trk".equals(this.reader.getLocalName()));
        AbstractFeature feature = ((Store)this.owner).types.track.newInstance();
        feature.setPropertyValue("sis:identifier", index);
        ArrayList<AbstractFeature> segments = null;
        List<Link> links = null;
        while (true) {
            block0 : switch (this.next()) {
                case 1: {
                    Object value;
                    String name = this.reader.getLocalName();
                    switch (this.isGPX() ? name : "") {
                        default: {
                            break block0;
                        }
                        case "name": 
                        case "cmt": 
                        case "desc": 
                        case "src": 
                        case "type": {
                            value = this.getElementText();
                            break;
                        }
                        case "number": {
                            value = this.getElementAsInteger();
                            break;
                        }
                        case "link": {
                            links = Metadata.addIfNonNull(links, this.unmarshal(Link.class));
                            break block0;
                        }
                        case "url": {
                            links = Metadata.addIfNonNull(links, Link.valueOf(this.getElementAsURI()));
                            break block0;
                        }
                        case "trk": {
                            throw new DataStoreContentException(this.nestedElement(name));
                        }
                        case "trkseg": {
                            if (segments == null) {
                                segments = new ArrayList<AbstractFeature>(8);
                            }
                            segments.add(this.parseTrackSegment(segments.size() + 1));
                            break block0;
                        }
                    }
                    feature.setPropertyValue(name, value);
                    break;
                }
                case 2: {
                    if (!"trk".equals(this.reader.getLocalName()) || !this.isGPX()) break;
                    if (segments != null) {
                        feature.setPropertyValue("trkseg", segments);
                    }
                    if (links != null) {
                        feature.setPropertyValue("link", links);
                    }
                    return feature;
                }
                case 8: {
                    throw new EOFException(this.endOfFile());
                }
            }
        }
    }
}

