/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.metadata.iso.constraint.DefaultConstraints;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.citation.Series;
import org.opengis.metadata.constraint.LegalConstraints;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.util.InternationalString;

public final class Copyright
implements LegalConstraints,
ResponsibleParty,
Citation,
CitationDate {
    @XmlAttribute(name="author", required=true)
    public String author;
    @XmlElement(name="year")
    public Integer year;
    @XmlElement(name="license")
    public URI license;

    public Copyright() {
    }

    private Copyright(LegalConstraints c, Locale locale) {
        if (!(c instanceof DefaultConstraints)) {
            return;
        }
        block0: for (DefaultResponsibility r : ((DefaultConstraints)c).getResponsibleParties()) {
            for (AbstractParty p : r.getParties()) {
                this.author = Types.toString(p.getName(), locale);
                if (this.author == null) continue;
                break block0;
            }
        }
        block2: for (Citation ci : ((DefaultConstraints)c).getReferences()) {
            for (CitationDate d : ci.getDates()) {
                Date date = d.getDate();
                if (date == null) continue;
                this.year = date.getYear() + 1900;
                break;
            }
            if (!(ci instanceof DefaultCitation)) continue;
            for (OnlineResource r : ((DefaultCitation)ci).getOnlineResources()) {
                this.license = r.getLinkage();
                if (this.license == null) continue;
                continue block2;
            }
        }
    }

    public static Copyright castOrCopy(LegalConstraints c, Locale locale) {
        return c == null || c instanceof Copyright ? (Copyright)c : new Copyright(c, locale);
    }

    public Collection<Restriction> getAccessConstraints() {
        return Collections.singleton(Restriction.COPYRIGHT);
    }

    public Collection<Restriction> getUseConstraints() {
        if (this.license != null) {
            return Arrays.asList(Restriction.COPYRIGHT, Restriction.valueOf((String)"LICENCE"));
        }
        return Collections.singleton(Restriction.COPYRIGHT);
    }

    public Collection<InternationalString> getOtherConstraints() {
        return Collections.emptySet();
    }

    public Collection<InternationalString> getUseLimitations() {
        return Collections.emptySet();
    }

    public Role getRole() {
        return Role.OWNER;
    }

    public InternationalString getOrganisationName() {
        return null;
    }

    public InternationalString getPositionName() {
        return null;
    }

    public String getIndividualName() {
        return this.author;
    }

    public Contact getContactInfo() {
        return null;
    }

    public InternationalString getTitle() {
        return null;
    }

    public Collection<InternationalString> getAlternateTitles() {
        return Collections.emptySet();
    }

    public Collection<? extends CitationDate> getDates() {
        return this.thisOrEmpty(this.year != null);
    }

    public Date getDate() {
        if (this.year != null) {
            return new Date(this.year - 1900, 0, 1);
        }
        return null;
    }

    public DateType getDateType() {
        return DateType.valueOf((String)"IN_FORCE");
    }

    public InternationalString getEdition() {
        return null;
    }

    public Date getEditionDate() {
        return null;
    }

    public Collection<Identifier> getIdentifiers() {
        return Collections.emptySet();
    }

    public Collection<ResponsibleParty> getCitedResponsibleParties() {
        return Collections.emptySet();
    }

    public Collection<PresentationForm> getPresentationForms() {
        return Collections.singleton(PresentationForm.DOCUMENT_DIGITAL);
    }

    public Series getSeries() {
        return null;
    }

    public InternationalString getOtherCitationDetails() {
        return null;
    }

    @Deprecated
    public InternationalString getCollectiveTitle() {
        return null;
    }

    public String getISBN() {
        return null;
    }

    public String getISSN() {
        return null;
    }

    private Collection<Copyright> thisOrEmpty(boolean condition) {
        return condition ? Collections.singleton(this) : Collections.emptySet();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Copyright) {
            Copyright that = (Copyright)obj;
            return Objects.equals(this.author, that.author) && Objects.equals(this.year, that.year) && Objects.equals(this.license, that.license);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.author, this.year, this.license);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Copyright");
        if (this.year != null) {
            sb.append(' ').append(this.year);
        }
        if (this.author != null) {
            sb.append(' ').append(this.author);
        }
        if (this.license != null) {
            sb.append(System.lineSeparator()).append(this.license);
        }
        return sb.toString();
    }
}

