/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Collection;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.storage.AbstractFeatureSet;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;

public class MemoryFeatureSet
extends AbstractFeatureSet {
    private final DefaultFeatureType type;
    private final Collection<AbstractFeature> features;

    public MemoryFeatureSet(StoreListeners parent, DefaultFeatureType type, Collection<AbstractFeature> features) {
        super(parent);
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonNull("features", features);
        this.type = type;
        this.features = features;
    }

    @Override
    public DefaultFeatureType getType() {
        return this.type;
    }

    @Override
    protected OptionalLong getFeatureCount() {
        return OptionalLong.of(this.features.size());
    }

    @Override
    public Stream<AbstractFeature> features(boolean parallel) {
        return parallel ? this.features.parallelStream() : this.features.stream();
    }
}

