/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Arrays;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.storage.AbstractResource;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.DimensionNameType;

public abstract class AbstractGridResource
extends AbstractResource
implements GridCoverageResource {
    protected AbstractGridResource(StoreListeners parent) {
        super(parent);
    }

    @Override
    public Optional<Envelope> getEnvelope() throws DataStoreException {
        GridGeometry gg = this.getGridGeometry();
        if (gg != null && gg.isDefined(2)) {
            return Optional.of(gg.getEnvelope());
        }
        return Optional.empty();
    }

    @Override
    protected void createMetadata(MetadataBuilder metadata) throws DataStoreException {
        super.createMetadata(metadata);
        metadata.addSpatialRepresentation(null, this.getGridGeometry(), false);
        for (SampleDimension band : this.getSampleDimensions()) {
            metadata.addNewBand(band);
        }
    }

    protected final RangeArgument validateRangeArgument(int numSampleDimensions, int[] range) {
        ArgumentChecks.ensureStrictlyPositive("numSampleDimensions", numSampleDimensions);
        if (range == null || range.length == 0) {
            long[] packed = new long[numSampleDimensions];
            for (int i = 1; i < numSampleDimensions; ++i) {
                packed[i] = (long)i << 32 | (long)i;
            }
            return new RangeArgument(packed);
        }
        long[] packed = new long[range.length];
        for (int i = 0; i < range.length; ++i) {
            int r = range[i];
            if (r < 0 || r >= numSampleDimensions) {
                throw new IllegalArgumentException(Resources.forLocale(this.getLocale()).getString((short)52, numSampleDimensions - 1, r));
            }
            packed[i] = (long)r << 32 | (long)i;
        }
        Arrays.sort(packed);
        int previous = -1;
        for (int i = 0; i < packed.length; ++i) {
            int r = (int)(packed[i] >>> 32);
            if (r == previous) {
                throw new IllegalArgumentException(Resources.forLocale(this.getLocale()).getString((short)53, r));
            }
            previous = r;
        }
        return new RangeArgument(packed);
    }

    protected static final class RangeArgument {
        private static final DimensionNameType BAND = DimensionNameType.valueOf((String)"BAND");
        private final long[] packed;
        private int first;
        private int last;
        private int interval;
        private SampleDimension.Builder builder;

        RangeArgument(long[] packed) {
            this.packed = packed;
            this.interval = 1;
        }

        public int getNumBands() {
            return this.packed.length;
        }

        public int getFirstSpecified() {
            for (long p : this.packed) {
                if ((int)p != 0) continue;
                return (int)(p >>> 32);
            }
            throw new IllegalStateException();
        }

        public int getSourceIndex(int i) {
            return (int)(this.packed[i] >>> 32);
        }

        public int getTargetIndex(int i) {
            return (int)this.packed[i];
        }

        public int getSubsampledIndex(int i) {
            return (this.getSourceIndex(i) - this.first) / this.interval;
        }

        public int getPixelStride() {
            return (this.last - this.first) / this.interval + 1;
        }

        public GridExtent insertBandDimension(GridExtent areaOfInterest, int bandDimension) {
            this.first = this.getSourceIndex(0);
            this.last = this.getSourceIndex(this.packed.length - 1);
            return areaOfInterest.insert(bandDimension, BAND, this.first, this.last, true);
        }

        public int[] insertSubsampling(int[] subsamplings, int bandDimension) {
            int[] delta = new int[this.packed.length - 1];
            for (int i = 0; i < delta.length; ++i) {
                delta[i] = this.getSourceIndex(i + 1) - this.getSourceIndex(i);
            }
            int[] divisors = MathFunctions.commonDivisors(delta);
            this.interval = divisors.length != 0 ? divisors[divisors.length - 1] : 1;
            subsamplings = ArraysExt.insert(subsamplings, bandDimension, 1);
            subsamplings[bandDimension] = this.interval;
            return subsamplings;
        }

        public SampleDimension.Builder builder() {
            if (this.builder == null) {
                this.builder = new SampleDimension.Builder();
            } else {
                this.builder.clear();
            }
            return this.builder;
        }
    }
}

