/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.sis.internal.sql.feature.Analyzer;
import org.apache.sis.storage.sql.SQLStoreProvider;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;

class TableReference {
    final String catalog;
    final String schema;
    final String table;
    final String freeText;

    TableReference(String catalog, String schema, String table, String freeText) {
        if (freeText != null && (freeText = freeText.trim()).isEmpty()) {
            freeText = null;
        }
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
        this.freeText = freeText;
    }

    static String[] splitName(GenericName name) {
        Object[] parts = (String[])name.getParsedNames().stream().map(LocalName::toString).toArray(String[]::new);
        ArraysExt.reverse(parts);
        return (String[])ArraysExt.resize(parts, 3);
    }

    final GenericName getName(Analyzer analyzer) {
        return analyzer.nameFactory.createLocalName(analyzer.namespace(this.catalog, this.schema), (CharSequence)this.table);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof TableReference) {
            TableReference other = (TableReference)obj;
            return this.table.equals(other.table) && Objects.equals(this.schema, other.schema) && Objects.equals(this.catalog, other.catalog);
        }
        return false;
    }

    public final int hashCode() {
        return this.table.hashCode() + 31 * Objects.hashCode(this.schema) + 37 * Objects.hashCode(this.catalog);
    }

    static TreeTable.Node newChild(TreeTable.Node parent, String name) {
        TreeTable.Node child = parent.newChild();
        child.setValue(TableColumn.NAME, name);
        return child;
    }

    static String toString(Object owner, Consumer<TreeTable.Node> appender) {
        DefaultTreeTable table = new DefaultTreeTable(TableColumn.NAME);
        TreeTable.Node root = table.getRoot();
        root.setValue(TableColumn.NAME, owner.getClass().getSimpleName());
        appender.accept(root);
        return table.toString();
    }

    public String toString() {
        return SQLStoreProvider.createTableName(this.catalog, this.schema, this.table).toString();
    }
}

