/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.AssociationRoleBuilder;
import org.apache.sis.feature.builder.AttributeRole;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.internal.sql.feature.Analyzer;
import org.apache.sis.internal.sql.feature.Features;
import org.apache.sis.internal.sql.feature.Relation;
import org.apache.sis.internal.sql.feature.Resources;
import org.apache.sis.internal.sql.feature.TableReference;
import org.apache.sis.internal.storage.AbstractFeatureSet;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;

final class Table
extends AbstractFeatureSet {
    private final DataSource source;
    final DefaultFeatureType featureType;
    final TableReference name;
    private final String[] attributeNames;
    private final String[] attributeColumns;
    private final String[] primaryKeys;
    private final Relation[] importedKeys;
    private final Relation[] exportedKeys;
    final Class<?> primaryKeyClass;
    private WeakValueHashMap<?, Object> instanceForPrimaryKeys;
    final boolean hasGeometry;

    Table(Analyzer analyzer, TableReference id, TableReference importedBy) throws SQLException, DataStoreException {
        super(analyzer.listeners);
        this.source = analyzer.source;
        this.name = id;
        String tableEsc = analyzer.escape(id.table);
        String schemaEsc = analyzer.escape(id.schema);
        LinkedHashMap<Object, Boolean> primaryKeys = new LinkedHashMap<Object, Boolean>();
        try (ResultSet reflect = analyzer.metadata.getPrimaryKeys(id.catalog, id.schema, id.table);){
            while (reflect.next()) {
                primaryKeys.put(analyzer.getUniqueString(reflect, "COLUMN_NAME"), null);
            }
        }
        this.primaryKeys = primaryKeys.isEmpty() ? null : primaryKeys.keySet().toArray(new String[primaryKeys.size()]);
        ArrayList<Relation> importedKeys = new ArrayList<Relation>();
        HashMap foreignerKeys = new HashMap();
        try (ResultSet reflect = analyzer.metadata.getImportedKeys(id.catalog, id.schema, id.table);){
            if (reflect.next()) {
                do {
                    Relation relation = new Relation(analyzer, Relation.Direction.IMPORT, reflect);
                    importedKeys.add(relation);
                    for (String column : relation.getForeignerKeys()) {
                        CollectionsExt.addToMultiValuesMap(foreignerKeys, column, relation);
                        relation = null;
                    }
                } while (!reflect.isClosed());
            }
        }
        ArrayList<Relation> exportedKeys = new ArrayList<Relation>();
        try (ResultSet reflect = analyzer.metadata.getExportedKeys(id.catalog, id.schema, id.table);){
            if (reflect.next()) {
                do {
                    Relation export;
                    if ((export = new Relation(analyzer, Relation.Direction.EXPORT, reflect)).equals(importedBy)) continue;
                    exportedKeys.add(export);
                } while (!reflect.isClosed());
            }
        }
        Class<?> primaryKeyClass = null;
        boolean primaryKeyNonNull = true;
        boolean hasGeometry = false;
        int startWithLowerCase = 0;
        ArrayList<Object> attributeNames = new ArrayList<Object>();
        ArrayList<Object> attributeColumns = new ArrayList<Object>();
        FeatureTypeBuilder feature = new FeatureTypeBuilder(analyzer.nameFactory, analyzer.functions.library, analyzer.locale);
        try (ResultSet reflect = analyzer.metadata.getColumns(id.catalog, schemaEsc, tableEsc, null);){
            while (reflect.next()) {
                String column = analyzer.getUniqueString(reflect, "COLUMN_NAME");
                boolean mandatory = Boolean.FALSE.equals(SQLUtilities.parseBoolean(reflect.getString("IS_NULLABLE")));
                boolean isPrimaryKey = primaryKeys.containsKey(column);
                List dependencies = (List)foreignerKeys.get(column);
                if (!column.isEmpty()) {
                    int firstLetter = column.codePointAt(0);
                    if (Character.isLowerCase(firstLetter)) {
                        ++startWithLowerCase;
                    } else if (Character.isUpperCase(firstLetter) && !CharSequences.isUpperCase(column)) {
                        --startWithLowerCase;
                    }
                }
                PropertyTypeBuilder attribute = null;
                if (isPrimaryKey || dependencies == null) {
                    attributeNames.add(column);
                    attributeColumns.add(column);
                    String typeName = reflect.getString("TYPE_NAME");
                    Class<Object> type = analyzer.functions.toJavaType(reflect.getInt("DATA_TYPE"), typeName);
                    if (type == null) {
                        analyzer.warning((short)4, typeName);
                        type = Object.class;
                    }
                    attribute = feature.addAttribute(type).setName((CharSequence)column);
                    if (CharSequence.class.isAssignableFrom(type)) {
                        int size = reflect.getInt("COLUMN_SIZE");
                        if (!reflect.wasNull()) {
                            ((AttributeTypeBuilder)attribute).setMaximalLength(size);
                        }
                    }
                    if (!mandatory) {
                        ((AttributeTypeBuilder)attribute).setMinimumOccurs(0);
                    }
                    if (isPrimaryKey) {
                        ((AttributeTypeBuilder)attribute).addRole(AttributeRole.IDENTIFIER_COMPONENT);
                        primaryKeyNonNull &= mandatory;
                        primaryKeyClass = Classes.findCommonClass(primaryKeyClass, type);
                        if (primaryKeys.put(column, SQLUtilities.parseBoolean(reflect.getString("IS_AUTOINCREMENT"))) != null) {
                            throw new DataStoreContentException(Resources.forLocale(analyzer.locale).getString((short)5, column));
                        }
                    }
                    if (Geometries.isKnownType(type)) {
                        CoordinateReferenceSystem crs = analyzer.functions.createGeometryCRS(reflect);
                        if (crs != null) {
                            ((AttributeTypeBuilder)attribute).setCRS(crs);
                        }
                        if (!hasGeometry) {
                            hasGeometry = true;
                            ((AttributeTypeBuilder)attribute).addRole(AttributeRole.DEFAULT_GEOMETRY);
                        }
                    }
                }
                if (dependencies == null) continue;
                int count = 0;
                for (Relation dependency : dependencies) {
                    AssociationRoleBuilder association;
                    if (dependency == null) continue;
                    GenericName typeName = dependency.getName(analyzer);
                    Table table = analyzer.table(dependency, typeName, id);
                    dependency.setPropertyName(column, count++);
                    if (table != null) {
                        dependency.setSearchTable(analyzer, table, table.primaryKeys, Relation.Direction.IMPORT);
                        association = feature.addAssociation(table.featureType);
                    } else {
                        association = feature.addAssociation(typeName);
                    }
                    association.setName((CharSequence)dependency.propertyName);
                    if (!mandatory) {
                        association.setMinimumOccurs(0);
                    }
                    if (attribute == null) continue;
                    ((AttributeTypeBuilder)attribute).setName(analyzer.nameFactory.createGenericName(null, new CharSequence[]{"pk", column}));
                    attributeNames.set(attributeNames.size() - 1, attribute.getName().toString());
                    attribute = null;
                }
            }
        }
        int count = 0;
        for (Relation dependency : exportedKeys) {
            AssociationRoleBuilder association;
            if (dependency == null) continue;
            GenericName typeName = dependency.getName(analyzer);
            String propertyName = typeName.tip().toString();
            if (startWithLowerCase > 0) {
                CharSequence words = CharSequences.camelCaseToWords(propertyName, true);
                int first = Character.codePointAt(words, 0);
                propertyName = new StringBuilder(words.length()).appendCodePoint(Character.toLowerCase(first)).append(words, Character.charCount(first), words.length()).toString();
            }
            String base = propertyName;
            while (feature.isNameUsed(propertyName)) {
                propertyName = base + '-' + ++count;
            }
            dependency.propertyName = propertyName;
            Table table = analyzer.table(dependency, typeName, null);
            if (table != null) {
                dependency.setSearchTable(analyzer, table, this.primaryKeys, Relation.Direction.EXPORT);
                association = feature.addAssociation(table.featureType);
            } else {
                association = feature.addAssociation(typeName);
            }
            association.setName((CharSequence)propertyName).setMinimumOccurs(0).setMaximumOccurs(Integer.MAX_VALUE);
        }
        if (primaryKeys.size() > 1) {
            if (primaryKeyNonNull) {
                primaryKeyClass = Numbers.wrapperToPrimitive(primaryKeyClass);
            }
            primaryKeyClass = Classes.changeArrayDimension(primaryKeyClass, 1);
        }
        feature.setName(id.getName(analyzer));
        String remarks = id.freeText;
        if (id instanceof Relation) {
            try (ResultSet reflect = analyzer.metadata.getTables(id.catalog, schemaEsc, tableEsc, null);){
                while (reflect.next()) {
                    remarks = analyzer.getUniqueString(reflect, "REMARKS");
                    if (remarks == null) continue;
                    if ((remarks = remarks.trim()).isEmpty()) {
                        remarks = null;
                        continue;
                    }
                    break;
                }
            }
        }
        if (remarks != null) {
            feature.setDefinition(remarks);
        }
        this.featureType = feature.build();
        this.importedKeys = Table.toArray(importedKeys);
        this.exportedKeys = Table.toArray(exportedKeys);
        this.primaryKeyClass = primaryKeyClass;
        this.hasGeometry = hasGeometry;
        this.attributeNames = attributeNames.toArray(new String[attributeNames.size()]);
        this.attributeColumns = attributeColumns.equals(attributeNames) ? this.attributeNames : attributeColumns.toArray(new String[attributeColumns.size()]);
    }

    private static Relation[] toArray(Collection<Relation> relations) {
        int size = relations.size();
        return size != 0 ? relations.toArray(new Relation[size]) : null;
    }

    final void setDeferredSearchTables(Analyzer analyzer, Map<GenericName, Table> tables) throws DataStoreException {
        block8: for (Relation.Direction direction : Relation.Direction.values()) {
            Relation[] relations;
            switch (direction) {
                case IMPORT: {
                    relations = this.importedKeys;
                    break;
                }
                case EXPORT: {
                    relations = this.exportedKeys;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            if (relations == null) continue;
            for (Relation relation : relations) {
                String[] referenced;
                if (relation.isSearchTableDefined()) continue;
                DefaultAssociationRole association = (DefaultAssociationRole)this.featureType.getProperty(relation.propertyName);
                Table table = tables.get(association.getValueType().getName());
                if (table == null) {
                    throw new InternalDataStoreException(association.toString());
                }
                switch (direction) {
                    case IMPORT: {
                        referenced = table.primaryKeys;
                        break;
                    }
                    case EXPORT: {
                        referenced = this.primaryKeys;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)direction);
                    }
                }
                relation.setSearchTable(analyzer, table, referenced, direction);
            }
        }
    }

    private static void appendAll(TreeTable.Node parent, Relation[] children, String arrow) {
        if (children != null) {
            for (Relation child : children) {
                child.appendTo(parent, arrow);
            }
        }
    }

    final void appendTo(TreeTable.Node parent) {
        parent = Relation.newChild(parent, this.featureType.getName().toString());
        for (String attribute : this.attributeNames) {
            TableReference.newChild(parent, attribute);
        }
        Table.appendAll(parent, this.importedKeys, " \u2192 ");
        Table.appendAll(parent, this.exportedKeys, " \u2190 ");
    }

    public String toString() {
        return TableReference.toString(this, n -> this.appendTo((TreeTable.Node)n));
    }

    @Override
    public final Optional<GenericName> getIdentifier() {
        return Optional.of(this.featureType.getName().toFullyQualifiedName());
    }

    @Override
    public final DefaultFeatureType getType() {
        return this.featureType;
    }

    final Relation getInverseOf(Relation exported, TableReference exportedOwner) {
        if (this.importedKeys != null && this.name.equals(exported)) {
            for (Relation relation : this.importedKeys) {
                if (!relation.equals(exportedOwner) || !relation.isInverseOf(exported)) continue;
                return relation;
            }
        }
        return null;
    }

    final synchronized WeakValueHashMap<?, Object> instanceForPrimaryKeys() {
        if (this.instanceForPrimaryKeys == null) {
            this.instanceForPrimaryKeys = new WeakValueHashMap(this.primaryKeyClass);
        }
        return this.instanceForPrimaryKeys;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final long countRows(DatabaseMetaData metadata, boolean approximate) throws SQLException {
        long count = -1L;
        String[] names = TableReference.splitName(this.featureType.getName());
        try (ResultSet reflect = metadata.getIndexInfo(names[2], names[1], names[0], false, approximate);){
            while (reflect.next()) {
                long n = reflect.getLong("CARDINALITY");
                if (reflect.wasNull()) continue;
                if (reflect.getShort("TYPE") == 0) {
                    long l = n;
                    return l;
                }
                if (n <= count) continue;
                count = n;
            }
            return count;
        }
    }

    @Override
    public Stream<AbstractFeature> features(boolean parallel) throws DataStoreException {
        Connection connection = null;
        try {
            connection = this.source.getConnection();
            Features iter = this.features(connection, new ArrayList<Relation>(), null);
            return (Stream)StreamSupport.stream(iter, parallel).onClose(iter);
        }
        catch (SQLException cause) {
            DataStoreException ex = new DataStoreException(Exceptions.unwrap(cause));
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    ex.addSuppressed(e);
                }
            }
            throw ex;
        }
    }

    final Features features(Connection connection, List<Relation> following, Relation noFollow) throws SQLException, InternalDataStoreException {
        return new Features(this, connection, this.attributeNames, this.attributeColumns, this.importedKeys, this.exportedKeys, following, noFollow);
    }
}

