/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.sql.feature.Analyzer;
import org.apache.sis.internal.sql.feature.Resources;
import org.apache.sis.internal.sql.feature.Table;
import org.apache.sis.internal.sql.feature.TableReference;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;

final class Relation
extends TableReference {
    private final Map<String, String> columns;
    private Table searchTable;
    String propertyName;
    private boolean useFullKey;

    Relation(Analyzer analyzer, Direction dir, ResultSet reflect) throws SQLException, DataStoreContentException {
        super(analyzer.getUniqueString(reflect, dir.catalog), analyzer.getUniqueString(reflect, dir.schema), analyzer.getUniqueString(reflect, dir.table), analyzer.getUniqueString(reflect, "FK_NAME"));
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        do {
            String column;
            if (m.put(column = analyzer.getUniqueString(reflect, dir.column), analyzer.getUniqueString(reflect, dir.containerColumn)) != null) {
                throw new DataStoreContentException(Resources.forLocale(analyzer.locale).getString((short)5, column));
            }
            if (reflect.next()) continue;
            reflect.close();
            break;
        } while (this.table.equals(reflect.getString(dir.table)) && Objects.equals(this.schema, reflect.getString(dir.schema)) && Objects.equals(this.catalog, reflect.getString(dir.catalog)));
        this.columns = CollectionsExt.compact(m);
    }

    final void setPropertyName(String column, int count) {
        if (this.columns.size() > 1) {
            this.propertyName = this.freeText;
        }
        if (this.propertyName == null) {
            this.propertyName = count == 0 ? column : column + '-' + count;
        }
    }

    final void setSearchTable(Analyzer analyzer, Table search, String[] primaryKeys, Direction direction) throws DataStoreException {
        Collection<String> referenced;
        boolean isDefined;
        boolean bl = isDefined = this.searchTable != null;
        if (isDefined || !this.equals(search.name)) {
            throw new InternalDataStoreException(isDefined ? analyzer.internalError() : super.toString());
        }
        this.searchTable = search;
        switch (direction) {
            case IMPORT: {
                referenced = this.columns.keySet();
                break;
            }
            case EXPORT: {
                referenced = this.columns.values();
                break;
            }
            default: {
                throw new AssertionError((Object)direction);
            }
        }
        this.useFullKey = referenced.containsAll(Arrays.asList(primaryKeys));
        if (this.useFullKey && this.columns.size() >= 2) {
            HashMap<String, String> copy = new HashMap<String, String>(this.columns);
            this.columns.clear();
            String[] stringArray = primaryKeys;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String key;
                String value = key = stringArray[i];
                block4 : switch (direction) {
                    case IMPORT: {
                        value = (String)copy.remove(key);
                        break;
                    }
                    case EXPORT: {
                        key = null;
                        Iterator it = copy.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry e = it.next();
                            if (!value.equals(e.getValue())) continue;
                            key = (String)e.getKey();
                            it.remove();
                            break block4;
                        }
                        break;
                    }
                }
                if (key != null && value != null && this.columns.put(key, value) == null) continue;
                throw new InternalDataStoreException(analyzer.internalError());
            }
            if (!copy.isEmpty()) {
                throw new DataStoreContentException(Resources.forLocale(analyzer.locale).getString((short)7, this.freeText, CollectionsExt.first(copy.keySet())));
            }
        }
    }

    final Table getSearchTable() throws InternalDataStoreException {
        if (this.searchTable != null) {
            return this.searchTable;
        }
        throw new InternalDataStoreException(super.toString());
    }

    final boolean isSearchTableDefined() {
        return this.searchTable != null;
    }

    final Collection<String> getSearchColumns() {
        return this.columns.keySet();
    }

    final Collection<String> getForeignerKeys() {
        return this.columns.values();
    }

    final boolean useFullKey() {
        return this.useFullKey;
    }

    final boolean isInverseOf(Relation other) {
        return this.columns.size() == other.columns.size() && this.columns.keySet().containsAll(other.columns.values()) && other.columns.keySet().containsAll(this.columns.values());
    }

    final void startFollowing(List<Relation> following) throws InternalDataStoreException {
        int i = following.size();
        while (--i >= 0) {
            if (following.get(i) != this) continue;
            throw new InternalDataStoreException(Errors.format((short)18));
        }
        following.add(this);
    }

    final void endFollowing(List<Relation> following) throws InternalDataStoreException {
        int last = following.size() - 1;
        if (last < 0 || following.remove(last) != this) {
            throw new InternalDataStoreException();
        }
    }

    void appendTo(TreeTable.Node parent, String arrow) {
        String label = super.toString();
        if (this.freeText != null) {
            label = this.freeText + " \u27f6 " + label;
        }
        TreeTable.Node node = Relation.newChild(parent, label);
        for (Map.Entry<String, String> e : this.columns.entrySet()) {
            Relation.newChild(node, e.getValue() + arrow + e.getKey());
        }
    }

    @Override
    public String toString() {
        return Relation.toString(this, n -> this.appendTo((TreeTable.Node)n, " \u2014 "));
    }

    static enum Direction {
        IMPORT("PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKCOLUMN_NAME"),
        EXPORT("FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "PKCOLUMN_NAME");

        final String catalog;
        final String schema;
        final String table;
        final String column;
        final String containerColumn;

        private Direction(String catalog, String schema, String table, String column, String containerColumn) {
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
            this.column = column;
            this.containerColumn = containerColumn;
        }
    }
}

