/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.sql.DataSource;
import org.apache.sis.internal.sql.feature.Analyzer;
import org.apache.sis.internal.sql.feature.SpatialFunctions;
import org.apache.sis.internal.sql.feature.Table;
import org.apache.sis.internal.sql.feature.TableReference;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureNaming;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.sql.SQLStore;
import org.apache.sis.util.collection.TreeTable;
import org.opengis.util.GenericName;

public final class Database {
    public static final String WILDCARD = "%";
    private final FeatureNaming<Table> tablesByNames;
    private final Table[] tables;
    final SpatialFunctions functions;
    public final boolean hasGeometry;

    public Database(SQLStore store, Connection connection, DataSource source, GenericName[] tableNames, StoreListeners listeners) throws SQLException, DataStoreException {
        Analyzer analyzer = new Analyzer(source, connection.getMetaData(), listeners, store.getLocale());
        String[] tableTypes = Database.getTableTypes(analyzer.metadata);
        LinkedHashSet<TableReference> declared = new LinkedHashSet<TableReference>();
        for (GenericName tableName : tableNames) {
            String[] names = TableReference.splitName(tableName);
            try (ResultSet reflect = analyzer.metadata.getTables(names[2], names[1], names[0], tableTypes);){
                while (reflect.next()) {
                    String table = analyzer.getUniqueString(reflect, "TABLE_NAME");
                    if (analyzer.isIgnoredTable(table)) continue;
                    declared.add(new TableReference(analyzer.getUniqueString(reflect, "TABLE_CAT"), analyzer.getUniqueString(reflect, "TABLE_SCHEM"), table, analyzer.getUniqueString(reflect, "REMARKS")));
                }
            }
        }
        ArrayList<Table> tableList = new ArrayList<Table>(tableNames.length);
        for (TableReference reference : declared) {
            tableList.add(analyzer.table(reference, reference.getName(analyzer), null));
        }
        boolean hasGeometry = false;
        this.tablesByNames = new FeatureNaming();
        for (Table table : analyzer.finish()) {
            this.tablesByNames.add(store, table.featureType.getName(), table);
            hasGeometry |= table.hasGeometry;
        }
        this.tables = tableList.toArray(new Table[tableList.size()]);
        this.functions = analyzer.functions;
        this.hasGeometry = hasGeometry;
    }

    private static String[] getTableTypes(DatabaseMetaData metadata) throws SQLException {
        HashSet<String> types = new HashSet<String>(4);
        try (ResultSet reflect = metadata.getTableTypes();){
            while (reflect.next()) {
                String type = reflect.getString("TABLE_TYPE");
                if (!"TABLE".equalsIgnoreCase(type) && !"VIEW".equalsIgnoreCase(type)) continue;
                types.add(type);
            }
        }
        return types.toArray(new String[types.size()]);
    }

    public final void listTables(DatabaseMetaData metadata, MetadataBuilder builder) throws SQLException {
        for (Table table : this.tables) {
            builder.addFeatureType(table.featureType, table.countRows(metadata, false));
        }
    }

    public final List<Resource> tables() {
        return UnmodifiableArrayList.wrap(this.tables);
    }

    public final FeatureSet findTable(SQLStore store, String name) throws IllegalNameException {
        return this.tablesByNames.get(store, name);
    }

    final void appendTo(TreeTable.Node parent) {
        for (Table child : this.tables) {
            child.appendTo(parent);
        }
    }

    public String toString() {
        return TableReference.toString(this, n -> this.appendTo((TreeTable.Node)n));
    }
}

