/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractStereographic;
import org.apache.sis.internal.referencing.provider.LambertConformal1SP;
import org.apache.sis.internal.referencing.provider.Mercator1SP;
import org.apache.sis.internal.referencing.provider.ObliqueStereographic;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

@XmlTransient
public final class PolarStereographicA
extends AbstractStereographic {
    private static final long serialVersionUID = 538262714055500925L;
    public static final String NAME = "Polar Stereographic (variant A)";
    public static final String IDENTIFIER = "9810";
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN = LambertConformal1SP.LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> SCALE_FACTOR;
    static final ParameterDescriptorGroup PARAMETERS;
    public static final int UPS_SHIFT = 2000000;

    public PolarStereographicA() {
        super(PARAMETERS);
    }

    public static String setParameters(ParameterValueGroup group, boolean north) {
        group.parameter("latitude_of_origin").setValue(north ? 90.0 : -90.0, Units.DEGREE);
        group.parameter("central_meridian").setValue(0.0, Units.DEGREE);
        group.parameter("scale_factor").setValue(0.994, Units.UNITY);
        group.parameter("false_easting").setValue(2000000.0, Units.METRE);
        group.parameter("false_northing").setValue(2000000.0, Units.METRE);
        return "Universal Polar Stereographic " + (north ? "North" : "South");
    }

    public static int isUPS(ParameterValueGroup group) {
        if (Numerics.epsilonEqual(group.parameter("scale_factor").doubleValue(Units.UNITY), 0.994, 1.0E-13) && Numerics.epsilonEqual(group.parameter("false_easting").doubleValue(Units.METRE), 2000000.0, 0.01) && Numerics.epsilonEqual(group.parameter("false_northing").doubleValue(Units.METRE), 2000000.0, 0.01) && Numerics.epsilonEqual(group.parameter("central_meridian").doubleValue(Units.DEGREE), 0.0, 8.999280057595393E-8)) {
            double \u03c6 = group.parameter("latitude_of_origin").doubleValue(Units.DEGREE);
            if (Numerics.epsilonEqual(\u03c6, 90.0, 8.999280057595393E-8)) {
                return 1;
            }
            if (Numerics.epsilonEqual(\u03c6, -90.0, 8.999280057595393E-8)) {
                return -1;
            }
        }
        return 0;
    }

    static {
        SCALE_FACTOR = Mercator1SP.SCALE_FACTOR;
        ParameterBuilder builder = PolarStereographicA.builder();
        LONGITUDE_OF_ORIGIN = PolarStereographicA.createLongitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addNamesAndIdentifiers((IdentifiedObject)ObliqueStereographic.LONGITUDE_OF_ORIGIN)).reidentify(Citations.GEOTIFF, "3095")).rename(Citations.GEOTIFF, "StraightVertPoleLong"));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier(IDENTIFIER)).addName(NAME)).addName(Citations.OGC, "Polar_Stereographic")).addName(Citations.GEOTIFF, "CT_PolarStereographic")).addName(Citations.PROJ4, "stere")).addIdentifier(Citations.GEOTIFF, "15")).createGroupForMapProjection(LATITUDE_OF_ORIGIN, LONGITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING);
    }
}

