/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import javax.measure.quantity.Angle;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.DatumShiftGridCompressed;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.referencing.provider.DatumShiftGridLoader;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@XmlTransient
public final class NADCON
extends AbstractProvider {
    private static final long serialVersionUID = -4707304160205218546L;
    private static final ParameterDescriptor<Path> LATITUDE;
    private static final ParameterDescriptor<Path> LONGITUDE;
    public static final ParameterDescriptorGroup PARAMETERS;

    public NADCON() {
        super(2, 2, PARAMETERS);
    }

    public Class<Transformation> getOperationType() {
        return Transformation.class;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws ParameterNotFoundException, FactoryException {
        Parameters pg = Parameters.castOrWrap(values);
        return InterpolatedTransform.createGeodeticTransformation(factory, NADCON.getOrLoad(pg.getMandatoryValue(LATITUDE), pg.getMandatoryValue(LONGITUDE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DatumShiftGridFile<Angle, Angle> getOrLoad(Path latitudeShifts, Path longitudeShifts) throws FactoryException {
        DatumShiftGridFile<Object, Object> grid;
        block18: {
            Path rlon;
            Path rlat = DataDirectory.DATUM_CHANGES.resolve(latitudeShifts).toAbsolutePath();
            AbstractMap.SimpleImmutableEntry<Path, Path> key = new AbstractMap.SimpleImmutableEntry<Path, Path>(rlat, rlon = DataDirectory.DATUM_CHANGES.resolve(longitudeShifts).toAbsolutePath());
            grid = DatumShiftGridFile.CACHE.peek(key);
            if (grid == null) {
                Cache.Handler<DatumShiftGridFile<?, ?>> handler = DatumShiftGridFile.CACHE.lock(key);
                try {
                    Loader loader;
                    grid = handler.peek();
                    if (grid != null) break block18;
                    Path file = latitudeShifts;
                    try {
                        ByteBuffer buffer = ByteBuffer.allocate(4096).order(ByteOrder.LITTLE_ENDIAN);
                        FloatBuffer fb = buffer.asFloatBuffer();
                        try (SeekableByteChannel in = Files.newByteChannel(rlat, new OpenOption[0]);){
                            DatumShiftGridLoader.log(NADCON.class, CharSequences.commonPrefix(latitudeShifts.toString(), longitudeShifts.toString()).toString() + '\u2026');
                            loader = new Loader(in, buffer, file);
                            loader.readGrid(fb, null, longitudeShifts);
                        }
                        buffer.clear();
                        file = longitudeShifts;
                        in = Files.newByteChannel(rlon, new OpenOption[0]);
                        try {
                            new Loader(in, buffer, file).readGrid(fb, loader, null);
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    catch (IOException | RuntimeException | NoninvertibleTransformException e) {
                        throw DatumShiftGridLoader.canNotLoad("NADCON", file, (Exception)e);
                    }
                    grid = DatumShiftGridCompressed.compress(loader.grid, null, loader.grid.accuracy);
                    grid = grid.useSharedData();
                }
                finally {
                    handler.putAndUnlock(grid);
                }
            }
        }
        return grid.castTo(Angle.class, Angle.class);
    }

    static {
        ParameterBuilder builder = NADCON.builder();
        LATITUDE = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8657")).addName("Latitude difference file")).create(Path.class, Paths.get("conus.las", new String[0]));
        LONGITUDE = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8658")).addName("Longitude difference file")).create(Path.class, Paths.get("conus.los", new String[0]));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("9613")).addName("NADCON")).createGroup(new GeneralParameterDescriptor[]{LATITUDE, LONGITUDE});
    }

    private static final class Loader
    extends DatumShiftGridLoader {
        private static final int DESCRIPTION_LENGTH = 64;
        private static final String NADCON = "NADCON";
        private final float x0;
        private final float y0;
        private final float \u0394x;
        private final float \u0394y;
        private final int nx;
        private final int ny;
        private final int nz;
        private final StringBuilder ascii;
        DatumShiftGridFile.Float<Angle, Angle> grid;

        Loader(ReadableByteChannel channel, ByteBuffer buffer, Path file) throws IOException, FactoryException {
            super(channel, buffer, file);
            this.ensureBufferContains(144);
            for (int i = 0; i < NADCON.length(); ++i) {
                if (buffer.get() == NADCON.charAt(i)) continue;
                throw this.unexpectedFormat();
            }
            if (Loader.isASCII(buffer)) {
                this.ascii = new StringBuilder();
                this.nx = Integer.parseInt(this.nextWord());
                this.ny = Integer.parseInt(this.nextWord());
                this.nz = Integer.parseInt(this.nextWord());
                this.x0 = Float.parseFloat(this.nextWord());
                this.\u0394x = Float.parseFloat(this.nextWord());
                this.y0 = Float.parseFloat(this.nextWord());
                this.\u0394y = Float.parseFloat(this.nextWord());
                Float.parseFloat(this.nextWord());
            } else {
                this.ascii = null;
                buffer.position(64);
                this.nx = buffer.getInt();
                this.ny = buffer.getInt();
                this.nz = buffer.getInt();
                this.x0 = buffer.getFloat();
                this.\u0394x = buffer.getFloat();
                this.y0 = buffer.getFloat();
                this.\u0394y = buffer.getFloat();
            }
            if (this.nx < 8 || this.ny < 1 || this.nz < 1 || !(this.\u0394x > 0.0f) || !(this.\u0394y > 0.0f) || Float.isNaN(this.x0) || Float.isNaN(this.y0)) {
                throw this.unexpectedFormat();
            }
            if (this.ascii == null) {
                this.skip((this.nx + 1) * 4 - buffer.position());
            }
        }

        private static boolean isASCII(ByteBuffer buffer) {
            int newLine = 0;
            while (buffer.hasRemaining()) {
                char c = (char)buffer.get();
                if (c == ' ' || c >= '+' && c <= '9' && c != ',' && c != '/') continue;
                if (c == '\r' || c == '\n') {
                    if (newLine != 0) continue;
                    newLine = buffer.position();
                    continue;
                }
                if (newLine == 0 && c >= ' ' & c <= '~') continue;
                return false;
            }
            if (newLine == 0) {
                return false;
            }
            buffer.position(newLine);
            return true;
        }

        private String nextWord() throws IOException {
            char c;
            do {
                this.ensureBufferContains(1);
            } while (Character.isWhitespace(c = (char)this.buffer.get()));
            this.ascii.setLength(0);
            do {
                this.ascii.append(c);
                this.ensureBufferContains(1);
            } while (!Character.isWhitespace(c = (char)this.buffer.get()));
            return this.ascii.toString();
        }

        private FactoryException unexpectedFormat() {
            return new FactoryException(Errors.format((short)139, NADCON, this.file));
        }

        final void readGrid(FloatBuffer fb, Loader latitudeShifts, Path longitudeShifts) throws IOException, FactoryException, NoninvertibleTransformException {
            double scale;
            int dim;
            if (latitudeShifts == null) {
                dim = 1;
                scale = 3600.0 * (double)this.\u0394y;
                this.grid = new DatumShiftGridFile.Float<Angle, Angle>(2, Units.DEGREE, Units.DEGREE, true, (double)this.x0, (double)this.y0, (double)this.\u0394x, this.\u0394y, this.nx, this.ny, PARAMETERS, this.file, longitudeShifts);
                this.grid.accuracy = 2.777777777777778E-8;
            } else {
                if (this.x0 != latitudeShifts.x0 || this.\u0394x != latitudeShifts.\u0394x || this.nx != latitudeShifts.nx || this.y0 != latitudeShifts.y0 || this.\u0394y != latitudeShifts.\u0394y || this.ny != latitudeShifts.ny || this.nz != latitudeShifts.nz) {
                    throw new FactoryException(Errors.format((short)82, latitudeShifts.file.getFileName(), this.file.getFileName()));
                }
                dim = 0;
                scale = -3600.0 * (double)this.\u0394x;
                this.grid = latitudeShifts.grid;
            }
            float[] array = this.grid.offsets[dim];
            if (this.ascii != null) {
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (float)(Double.parseDouble(this.nextWord()) / scale);
                }
            } else {
                int i;
                int n;
                this.syncView(fb);
                int forCurrentRow = 0;
                for (i = 0; i < array.length; i += n) {
                    int remaining;
                    if (forCurrentRow == 0) {
                        if (!fb.hasRemaining()) {
                            this.fillBuffer(fb);
                        }
                        if (fb.get() != 0.0f) {
                            throw this.unexpectedFormat();
                        }
                        forCurrentRow = this.nx;
                    }
                    if ((remaining = fb.remaining()) == 0) {
                        this.fillBuffer(fb);
                        remaining = fb.remaining();
                    }
                    n = Math.min(forCurrentRow, remaining);
                    fb.get(array, i, n);
                    forCurrentRow -= n;
                }
                i = 0;
                while (i < array.length) {
                    int n2 = i++;
                    array[n2] = (float)((double)array[n2] / scale);
                }
            }
        }

        private void fillBuffer(FloatBuffer fb) throws IOException {
            this.buffer.position(fb.position() * 4).limit(fb.limit() * 4);
            this.ensureBufferContains(4);
            this.syncView(fb);
        }

        private void syncView(FloatBuffer fb) {
            if (this.buffer.position() % 4 != 0) {
                this.buffer.compact();
            }
            fb.limit(this.buffer.limit() / 4).position(this.buffer.position() / 4);
        }
    }
}

