/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;

@XmlTransient
abstract class GeodeticOperation
extends AbstractProvider {
    private static final long serialVersionUID = 5431035501162127059L;
    final GeodeticOperation[] redimensioned;

    GeodeticOperation(int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters, GeodeticOperation[] redimensioned) {
        super(sourceDimensions, targetDimensions, parameters);
        this.redimensioned = redimensioned;
    }

    Class<? extends GeodeticOperation> variant3D() {
        return null;
    }

    @Override
    public final OperationMethod redimension(int sourceDimensions, int targetDimensions) {
        GeodeticOperation m;
        if (this.redimensioned != null && (sourceDimensions & 0xFFFFFFFE) == 2 && (targetDimensions & 0xFFFFFFFE) == 2 && (m = this.redimensioned[(sourceDimensions & 1) << 1 | targetDimensions & 1]) != null) {
            assert (m.getSourceDimensions() == sourceDimensions) : sourceDimensions;
            assert (m.getTargetDimensions() == targetDimensions) : targetDimensions;
            return m;
        }
        return super.redimension(sourceDimensions, targetDimensions);
    }

    @Override
    public Class<? extends SingleOperation> getOperationType() {
        return Transformation.class;
    }

    @Override
    public boolean isInvertible() {
        return true;
    }
}

