/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.internal.referencing.provider.GeographicToGeocentric;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

public final class GeocentricToGeographic
extends GeodeticOperation {
    private static final long serialVersionUID = 8459294628751497567L;
    public static final String NAME = "Geocentric_To_Ellipsoid";
    public static final ParameterDescriptorGroup PARAMETERS = ((ParameterBuilder)GeocentricToGeographic.builder().addName(Citations.OGC, "Geocentric_To_Ellipsoid")).createGroupForMapProjection(GeographicToGeocentric.DIMENSION);

    public GeocentricToGeographic() {
        this(3, new GeocentricToGeographic[4]);
        this.redimensioned[2] = new GeocentricToGeographic(2, this.redimensioned);
        this.redimensioned[3] = this;
    }

    private GeocentricToGeographic(int targetDimensions, GeodeticOperation[] redimensioned) {
        super(3, targetDimensions, PARAMETERS, redimensioned);
    }

    public Class<Conversion> getOperationType() {
        return Conversion.class;
    }

    @Override
    public int getEllipsoidsMask() {
        return 2;
    }

    @Override
    public boolean isInvertible() {
        return false;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        MathTransform tr = GeographicToGeocentric.create(factory, Parameters.castOrWrap(values));
        try {
            tr = tr.inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new FactoryException((Throwable)e);
        }
        return tr;
    }
}

