/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import org.apache.sis.internal.referencing.provider.Equirectangular;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.util.Static;
import org.opengis.parameter.ParameterDescriptor;

final class ESRI
extends Static {
    static final ParameterDescriptor<Double> CENTRAL_MERIDIAN;
    static final ParameterDescriptor<Double> FALSE_EASTING;
    static final ParameterDescriptor<Double> FALSE_NORTHING;

    private ESRI() {
    }

    static ParameterDescriptor<Double> asPrimary(ParameterDescriptor<Double> template, ParameterBuilder builder) {
        return MapProjection.alternativeAuthority(template, Citations.ESRI, builder).createBounded((MeasurementRange)((DefaultParameterDescriptor)template).getValueDomain(), (Double)template.getDefaultValue());
    }

    static {
        ParameterBuilder builder = MapProjection.builder();
        FALSE_EASTING = ESRI.asPrimary(Equirectangular.FALSE_EASTING, builder);
        FALSE_NORTHING = ESRI.asPrimary(Equirectangular.FALSE_NORTHING, builder);
        ParameterDescriptor<Double> template = Equirectangular.LONGITUDE_OF_ORIGIN;
        CENTRAL_MERIDIAN = MapProjection.createLongitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addName(MapProjection.sameNameAs(Citations.ESRI, template))).addName(MapProjection.sameNameAs(Citations.OGC, template))).addName(MapProjection.sameNameAs(Citations.PROJ4, template)));
    }
}

