/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.referencing.factory.FactoryDataException;
import org.apache.sis.referencing.factory.MissingFactoryResourceException;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.FactoryException;

class DatumShiftGridLoader {
    static final double DEGREES_TO_SECONDS = 3600.0;
    static final double SECOND_PRECISION = 1.0E-4;
    final Path file;
    private final ReadableByteChannel channel;
    final ByteBuffer buffer;

    DatumShiftGridLoader(ReadableByteChannel channel, ByteBuffer buffer, Path file) throws IOException {
        this.file = file;
        this.buffer = buffer;
        this.channel = channel;
        channel.read(buffer);
        buffer.flip();
    }

    final void ensureBufferContains(int n) throws IOException {
        assert (n >= 0 && n <= this.buffer.capacity()) : n;
        if ((n -= this.buffer.remaining()) > 0) {
            int c;
            this.buffer.compact();
            do {
                if ((c = this.channel.read(this.buffer)) > 0) continue;
                if (c != 0) {
                    throw new EOFException(Errors.format((short)137, this.file));
                }
                throw new IOException(Errors.format((short)12, this.file));
            } while ((n -= c) > 0);
            this.buffer.flip();
        }
    }

    final void skip(int n) throws IOException {
        int p;
        while ((p = this.buffer.position() + n) > this.buffer.limit()) {
            this.buffer.clear();
            this.ensureBufferContains(Math.min(n -= this.buffer.remaining(), this.buffer.capacity()));
        }
        this.buffer.position(p);
    }

    static void log(Class<?> caller, Object file) {
        LogRecord record = Resources.forLocale(null).getLogRecord(Level.FINE, (short)32, file);
        record.setLoggerName("org.apache.sis.referencing.operation");
        Logging.log(caller, "createMathTransform", record);
    }

    static FactoryException canNotLoad(String format, Path file, Exception cause) {
        String message = Errors.format((short)10, format, file);
        if (cause instanceof NoSuchFileException) {
            return new MissingFactoryResourceException(message, cause);
        }
        return new FactoryDataException(message, cause);
    }
}

