/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.Arrays;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.util.collection.Cache;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.NoninvertibleTransformException;

abstract class DatumShiftGridFile<C extends Quantity<C>, T extends Quantity<T>>
extends DatumShiftGrid<C, T> {
    private static final long serialVersionUID = -4471670781277328193L;
    static final Cache<Object, DatumShiftGridFile<?, ?>> CACHE = new Cache<Object, DatumShiftGridFile<?, ?>>(4, 32768L, true){

        @Override
        protected int cost(DatumShiftGridFile<?, ?> grid) {
            int p = 1;
            for (Object array : grid.getData()) {
                p *= Array.getLength(array);
            }
            return p;
        }
    };
    private final ParameterDescriptorGroup descriptor;
    private final Path[] files;
    protected final int nx;
    double accuracy;

    DatumShiftGridFile(Unit<C> coordinateUnit, Unit<T> translationUnit, boolean isCellValueRatio, double x0, double y0, double \u0394x, double \u0394y, int nx, int ny, ParameterDescriptorGroup descriptor, Path ... files) throws NoninvertibleTransformException {
        super(coordinateUnit, new AffineTransform2D(\u0394x, 0.0, 0.0, \u0394y, x0, y0).inverse(), new int[]{nx, ny}, isCellValueRatio, translationUnit);
        this.descriptor = descriptor;
        this.files = files;
        this.nx = nx;
        this.accuracy = Double.NaN;
    }

    protected DatumShiftGridFile(DatumShiftGridFile<C, T> other) {
        super(other);
        this.descriptor = other.descriptor;
        this.files = other.files;
        this.nx = other.nx;
        this.accuracy = other.accuracy;
    }

    final <NC extends Quantity<NC>, NT extends Quantity<NT>> DatumShiftGridFile<NC, NT> castTo(Class<NC> coordinateType, Class<NT> translationType) {
        super.getCoordinateUnit().asType(coordinateType);
        super.getTranslationUnit().asType(translationType);
        return this;
    }

    protected final DatumShiftGridFile<C, T> useSharedData() {
        Object[] data = this.getData();
        for (DatumShiftGridFile grid : CACHE.values()) {
            Object[] other = grid.getData();
            if (!Arrays.deepEquals(data, other)) continue;
            return this.setData(other);
        }
        return this;
    }

    protected abstract DatumShiftGridFile<C, T> setData(Object[] var1);

    protected abstract Object[] getData();

    @Override
    public double getCellPrecision() {
        return this.accuracy / 10.0;
    }

    @Override
    public final ParameterDescriptorGroup getParameterDescriptors() {
        return this.descriptor;
    }

    @Override
    public final void getParameterValues(Parameters parameters) {
        int i = 0;
        for (GeneralParameterDescriptor gd : this.descriptor.descriptors()) {
            ParameterDescriptor d;
            if (!(gd instanceof ParameterDescriptor) || !Path.class.isAssignableFrom((d = (ParameterDescriptor)gd).getValueClass())) continue;
            if (i >= this.files.length) break;
            parameters.getOrCreate(d).setValue((Object)this.files[i++]);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (super.equals(other)) {
            DatumShiftGridFile that = (DatumShiftGridFile)other;
            return Arrays.equals(this.files, that.files) && Arrays.deepEquals(this.getData(), that.getData());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.files);
    }

    static final class Float<C extends Quantity<C>, T extends Quantity<T>>
    extends DatumShiftGridFile<C, T> {
        private static final long serialVersionUID = -9221609983475286496L;
        final float[][] offsets;

        Float(int dim, Unit<C> coordinateUnit, Unit<T> translationUnit, boolean isCellValueRatio, double x0, double y0, double \u0394x, double \u0394y, int nx, int ny, ParameterDescriptorGroup descriptor, Path ... files) throws NoninvertibleTransformException {
            super(coordinateUnit, translationUnit, isCellValueRatio, x0, y0, \u0394x, \u0394y, nx, ny, descriptor, files);
            this.offsets = new float[dim][];
            int size = Math.multiplyExact(nx, ny);
            for (int i = 0; i < dim; ++i) {
                this.offsets[i] = new float[size];
                Arrays.fill(this.offsets[i], java.lang.Float.NaN);
            }
        }

        private Float(DatumShiftGridFile<C, T> grid, float[][] offsets) {
            super(grid);
            this.offsets = offsets;
        }

        @Override
        protected final DatumShiftGridFile<C, T> setData(Object[] other) {
            return new Float<C, T>(this, (float[][])other);
        }

        @Override
        protected final Object[] getData() {
            return this.offsets;
        }

        @Override
        public final int getTranslationDimensions() {
            return this.offsets.length;
        }

        @Override
        public final double getCellValue(int dim, int gridX, int gridY) {
            return DecimalFunctions.floatToDouble(this.offsets[dim][gridX + gridY * this.nx]);
        }
    }
}

