/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

@XmlTransient
public abstract class AbstractProvider
extends DefaultOperationMethod
implements MathTransformProvider {
    private static final long serialVersionUID = 2239172887926695217L;

    AbstractProvider(Map<String, ?> properties, int sourceDimension, int targetDimension, ParameterDescriptorGroup parameters) {
        super(properties, sourceDimension, targetDimension, parameters);
    }

    AbstractProvider(int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters) {
        super(AbstractProvider.toMap((IdentifiedObject)parameters), sourceDimensions, targetDimensions, parameters);
    }

    private static Map<String, Object> toMap(IdentifiedObject parameters) {
        Collection aliases;
        ArgumentChecks.ensureNonNull("parameters", parameters);
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", parameters.getName());
        Set identifiers = parameters.getIdentifiers();
        int size = identifiers.size();
        if (size != 0) {
            properties.put("identifiers", identifiers.toArray(new ReferenceIdentifier[size]));
        }
        if ((size = (aliases = parameters.getAlias()).size()) != 0) {
            properties.put("alias", aliases.toArray(new GenericName[size]));
        }
        return properties;
    }

    static ParameterBuilder builder() {
        return ((ParameterBuilder)new ParameterBuilder().setCodeSpace(Citations.EPSG, "EPSG")).setRequired(true);
    }

    static ParameterBuilder addNameAndLegacy(ParameterBuilder builder, String name, String legacy) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addName(name)).setDeprecated(true)).setRemarks((CharSequence)Vocabulary.formatInternational((short)96, (Object)name))).addName(legacy)).setDeprecated(false)).setRemarks(null);
    }

    static ParameterBuilder addIdentifierAndLegacy(ParameterBuilder builder, String code, String legacy) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier(code)).setDeprecated(true)).setRemarks((CharSequence)Vocabulary.formatInternational((short)96, (Object)code))).addIdentifier(legacy)).setDeprecated(false)).setRemarks(null);
    }

    static ParameterDescriptor<Double> createZeroConstant(ParameterBuilder builder) {
        Double zero = 0.0;
        return builder.createBounded(MeasurementRange.create(-0.0, true, zero, true, Units.DEGREE), zero);
    }

    static ParameterDescriptor<Double> createMandatoryLatitude(ParameterBuilder builder) {
        return builder.createBounded(-90.0, 90.0, Double.NaN, Units.DEGREE);
    }

    static ParameterDescriptor<Double> createLatitude(ParameterBuilder builder, boolean includePoles) {
        return builder.createBounded(MeasurementRange.create(-90.0, includePoles, 90.0, includePoles, Units.DEGREE), 0.0);
    }

    static ParameterDescriptor<Double> createLongitude(ParameterBuilder builder) {
        return builder.createBounded(-180.0, 180.0, 0.0, Units.DEGREE);
    }

    static ParameterDescriptor<Double> createScale(ParameterBuilder builder) {
        return builder.createStrictlyPositive(1.0, Units.UNITY);
    }

    static ParameterDescriptor<Double> createShift(ParameterBuilder builder) {
        return builder.create(0.0, Units.METRE);
    }

    public String resolveAmbiguity(DefaultMathTransformFactory.Context context) {
        return null;
    }

    public int getEllipsoidsMask() {
        return 0;
    }

    public boolean isInvertible() {
        return false;
    }
}

