/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.geom.Path2D;
import org.opengis.referencing.operation.TransformException;

public abstract class Bezier {
    private static final int DEPTH_LIMIT = 12;
    private static final int MAXIMUM_ITERATIONS = 4;
    private final Path2D path;
    protected double \u03b5x;
    protected double \u03b5y;
    private double x0;
    private double y0;
    private double dx0;
    private double dy0;
    protected double dx;
    protected double dy;
    protected final double[] point;
    protected int depth;
    protected boolean forceCubic;

    protected Bezier(int dimension) {
        this.point = new double[dimension];
        this.path = new Path2D.Double();
    }

    protected abstract void evaluateAt(double var1) throws TransformException;

    public final Path2D build() throws TransformException {
        this.evaluateAt(0.0);
        this.x0 = this.point[0];
        this.y0 = this.point[1];
        this.dx0 = this.dx;
        this.dy0 = this.dy;
        this.path.moveTo(this.x0, this.y0);
        this.evaluateAt(0.5);
        double x2 = this.point[0];
        double y2 = this.point[1];
        double dx2 = this.dx;
        double dy2 = this.dy;
        this.evaluateAt(1.0);
        this.sequence(0.0, 1.0, x2, y2, dx2, dy2, this.point[0], this.point[1], this.dx, this.dy);
        return this.path;
    }

    private void sequence(double tmin, double tmax, double x2, double y2, double dx2, double dy2, double x4, double y4, double dx4, double dy4) throws TransformException {
        this.evaluateAt(0.25 * tmin + 0.75 * tmax);
        double x3 = this.point[0];
        double y3 = this.point[1];
        double dx3 = this.dx;
        double dy3 = this.dy;
        double tx = this.\u03b5x;
        double ty = this.\u03b5y;
        this.evaluateAt(0.75 * tmin + 0.25 * tmax);
        double x1 = this.point[0];
        double y1 = this.point[1];
        double dx1 = this.dx;
        double dy1 = this.dy;
        if (tx < this.\u03b5x) {
            this.\u03b5x = tx;
        }
        if (ty < this.\u03b5y) {
            this.\u03b5y = ty;
        }
        if (this.curve(x1, y1, x2, y2, x3, y3, x4, y4, dx4, dy4)) {
            this.x0 = x4;
            this.y0 = y4;
            this.dx0 = dx4;
            this.dy0 = dy4;
        } else {
            ++this.depth;
            double \u03b5xo = this.\u03b5x;
            double \u03b5yo = this.\u03b5y;
            double th = 0.5 * (tmin + tmax);
            this.sequence(tmin, th, x1, y1, dx1, dy1, x2, y2, dx2, dy2);
            this.sequence(th, tmax, x3, y3, dx3, dy3, x4, y4, dx4, dy4);
            this.\u03b5x = \u03b5xo;
            this.\u03b5y = \u03b5yo;
            --this.depth;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean curve(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double dx4, double dy4) {
        double by;
        double bx;
        x1 -= this.x0;
        x2 -= this.x0;
        x3 -= this.x0;
        y1 -= this.y0;
        y2 -= this.y0;
        y3 -= this.y0;
        double \u0394x = x4 - this.x0;
        double \u0394y = y4 - this.y0;
        if (!this.forceCubic && (Math.abs(this.dx0) >= Math.abs(this.dy0) ? Math.abs(\u0394x * (this.dy0 / this.dx0) - \u0394y) <= this.\u03b5y : Math.abs(\u0394y * (this.dx0 / this.dy0) - \u0394x) <= this.\u03b5x) && (Math.abs(dx4) >= Math.abs(dy4) ? Math.abs(\u0394x * (dy4 / dx4) - \u0394y) <= this.\u03b5y : Math.abs(\u0394y * (dx4 / dy4) - \u0394x) <= this.\u03b5x)) {
            if (this.depth < 12) {
                if (Math.abs(\u0394x) >= Math.abs(\u0394y)) {
                    double m = \u0394y / \u0394x;
                    if (Math.abs(m * x2 - y2) > this.\u03b5y) return false;
                    if (Math.abs(m * x1 - y1) > this.\u03b5y) return false;
                    if (Math.abs(m * x3 - y3) > this.\u03b5y) {
                        return false;
                    }
                } else {
                    double m = \u0394x / \u0394y;
                    if (Math.abs(m * y2 - x2) > this.\u03b5x) return false;
                    if (Math.abs(m * y1 - x1) > this.\u03b5x) return false;
                    if (Math.abs(m * y3 - x3) > this.\u03b5x) {
                        return false;
                    }
                }
            }
            this.path.lineTo(x4, y4);
            return true;
        }
        double m = ((8.0 * x2 - 4.0 * \u0394x) * dy4 - (8.0 * y2 - 4.0 * \u0394y) * dx4) / (3.0 * (this.dx0 * dy4 - this.dy0 * dx4));
        double ax = m * this.dx0;
        double ay = m * this.dy0;
        if (Math.abs(dx4) >= Math.abs(dy4)) {
            bx = (8.0 * x2 - \u0394x) / 3.0 - ax;
            by = \u0394y - (\u0394x - bx) * (dy4 / dx4);
        } else {
            by = (8.0 * y2 - \u0394y) / 3.0 - ay;
            bx = \u0394x - (\u0394y - by) * (dx4 / dy4);
        }
        if (this.depth < 12) {
            double x = 0.421875 * ax + 0.140625 * bx + 0.015625 * \u0394x;
            double y = 0.421875 * ay + 0.140625 * by + 0.015625 * \u0394y;
            if ((Math.abs(x - x1) > this.\u03b5x || Math.abs(y - y1) > this.\u03b5y) && !this.isNear(x, y, 0.25, ax, ay, 1.6875, bx, by, 1.125, \u0394x, \u0394y, 0.1875, x1, y1)) {
                return false;
            }
            x = 0.140625 * ax + 0.421875 * bx + 0.421875 * \u0394x;
            y = 0.140625 * ay + 0.421875 * by + 0.421875 * \u0394y;
            if ((Math.abs(x - x3) > this.\u03b5x || Math.abs(y - y3) > this.\u03b5y) && !this.isNear(x, y, 0.75, ax, ay, 0.1875, bx, by, 1.125, \u0394x, \u0394y, 1.6875, x3, y3)) {
                return false;
            }
        }
        if (!this.forceCubic) {
            double d;
            double \u0394qx = (3.0 * (bx - ax) - \u0394x) / 2.0;
            if (Math.abs(d) <= 2.0 * this.\u03b5x) {
                double d2;
                double \u0394qy = (3.0 * (by - ay) - \u0394y) / 2.0;
                if (Math.abs(d2) <= 2.0 * this.\u03b5y) {
                    double qx = (3.0 * ax + \u0394qx) / 2.0;
                    double qy = (3.0 * ay + \u0394qy) / 2.0;
                    this.path.quadTo(qx + this.x0, qy + this.y0, x4, y4);
                    return true;
                }
            }
        }
        this.path.curveTo(ax + this.x0, ay + this.y0, bx + this.x0, by + this.y0, x4, y4);
        return true;
    }

    private boolean isNear(double x, double y, double t, double ax, double ay, double am, double bx, double by, double bm, double x4, double y4, double cm, double xp, double yp) {
        double \u0394ax = bx - ax;
        double \u0394ay = by - ay;
        double \u0394bx = x4 - bx;
        double \u0394by = y4 - by;
        int n = 4;
        while (true) {
            double yi;
            double xi;
            double offset;
            double slope;
            double tx = am * ax + bm * \u0394ax + cm * \u0394bx;
            double ty = am * ay + bm * \u0394ay + cm * \u0394by;
            if (Math.abs(tx) >= Math.abs(ty)) {
                slope = ty / tx;
                offset = y - slope * x;
                xi = ((yp - offset) * slope + xp) / (slope * slope + 1.0);
                t += (xi - x) / tx;
            } else {
                slope = tx / ty;
                offset = x - slope * y;
                yi = ((xp - offset) * slope + yp) / (slope * slope + 1.0);
                t += (yi - y) / ty;
            }
            if (t < 0.0) {
                t = 0.0;
            } else if (t > 1.0) {
                t = 1.0;
            }
            am = 1.0 - t;
            bm = 3.0 * am;
            cm = t * t;
            xi = ((ax * am + t * bx) * bm + x4 * cm) * t;
            yi = ((ay * am + t * by) * bm + y4 * cm) * t;
            if (Math.abs(xi - xp) <= this.\u03b5x && Math.abs(yi - yp) <= this.\u03b5y) {
                return true;
            }
            if (--n < 0 || !(Math.abs(xi - x) > this.\u03b5x / 2.0) && !(Math.abs(yi - y) > this.\u03b5y / 2.0)) break;
            am *= bm;
            bm *= 2.0 * t;
            cm *= 3.0;
            x = xi;
            y = yi;
        }
        return false;
    }
}

