/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.SetOfUnknownSize;
import org.apache.sis.internal.util.UnmodifiableArrayList;

public class LazySet<E>
extends SetOfUnknownSize<E> {
    private final Class<E> service;
    private Iterator<? extends E> sourceIterator;
    private E[] cachedElements;
    private int numCached;

    public LazySet(Class<E> service) {
        Objects.requireNonNull(service);
        this.service = service;
    }

    public LazySet(Iterator<? extends E> iterator) {
        Objects.requireNonNull(iterator);
        this.sourceIterator = iterator;
        this.service = null;
        this.createCache();
    }

    public void reload() {
        if (this.service != null) {
            this.sourceIterator = null;
            this.cachedElements = null;
            this.numCached = 0;
        }
    }

    protected E[] initialValues() {
        return null;
    }

    private boolean createCache() {
        this.cachedElements = this.initialValues();
        if (this.cachedElements != null) {
            this.numCached = this.cachedElements.length;
            if (this.numCached != 0) {
                return true;
            }
        }
        this.cachedElements = new Object[4];
        return false;
    }

    private boolean canPullMore() {
        if (this.sourceIterator == null && this.cachedElements == null) {
            this.sourceIterator = DefaultFactories.createServiceLoader(this.service).iterator();
            if (this.createCache()) {
                return true;
            }
        }
        if (this.sourceIterator != null) {
            if (this.sourceIterator.hasNext()) {
                return true;
            }
            this.sourceIterator = null;
        }
        return false;
    }

    @Override
    public final boolean isEmpty() {
        return this.numCached == 0 && !this.canPullMore();
    }

    @Override
    public final int size() {
        if (this.canPullMore()) {
            while (this.sourceIterator.hasNext()) {
                this.cache(this.next(this.sourceIterator));
            }
            this.sourceIterator = null;
        }
        return this.numCached;
    }

    protected E next(Iterator<? extends E> it) {
        return it.next();
    }

    protected void cache(E element) {
        if (this.numCached >= this.cachedElements.length) {
            this.cachedElements = Arrays.copyOf(this.cachedElements, this.numCached << 1);
        }
        this.cachedElements[this.numCached++] = element;
    }

    protected final List<E> cached() {
        return UnmodifiableArrayList.wrap(this.cachedElements, 0, this.numCached);
    }

    final boolean exists(int index) {
        assert (index <= this.numCached) : index;
        return index < this.numCached || this.canPullMore();
    }

    final E get(int index) {
        assert (this.numCached <= this.cachedElements.length) : this.numCached;
        assert (index <= this.numCached) : index;
        if (index >= this.numCached) {
            if (this.canPullMore()) {
                this.cache(this.next(this.sourceIterator));
            } else {
                throw new NoSuchElementException();
            }
        }
        return this.cachedElements[index];
    }

    @Override
    public final Iterator<E> iterator() {
        return new Iterator<E>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return LazySet.this.exists(this.cursor);
            }

            @Override
            public E next() {
                return LazySet.this.get(this.cursor++);
            }
        };
    }
}

