/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.metadata.iso.extent.Extents;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;

public final class ExtentSelector<T> {
    private final GeographicBoundingBox areaOfInterest;
    private T best;
    private double largestArea;

    public ExtentSelector(Extent areaOfInterest) {
        this.areaOfInterest = Extents.getGeographicBoundingBox(areaOfInterest);
    }

    public boolean evaluate(Extent extent, T object) {
        double area = Extents.area(Extents.intersection(Extents.getGeographicBoundingBox(extent), this.areaOfInterest));
        if (!(this.best == null || area > this.largestArea || !Double.isNaN(area) && Double.isNaN(this.largestArea))) {
            return false;
        }
        this.largestArea = area;
        this.best = object;
        return true;
    }

    public T best() {
        return this.best;
    }
}

