/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.measure.IncommensurableException;
import javax.measure.UnitConverter;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.collection.Containers;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;

public final class CoordinateOperations
extends SystemListener {
    public static final String BURSA_WOLF_KEY = "bursaWolf";
    public static final String PARAMETERS_KEY = "parameters";
    public static final String OPERATION_TYPE_KEY = "operationType";
    private static final Set<Integer>[] CACHE = new Set[11];
    private static volatile DefaultCoordinateOperationFactory factory;

    private CoordinateOperations() {
        super("org.apache.sis.referencing");
    }

    @Override
    protected void classpathChanged() {
        factory = null;
    }

    public static DefaultCoordinateOperationFactory factory() {
        DefaultCoordinateOperationFactory c = factory;
        if (c == null) {
            factory = c = DefaultFactories.forBuildin(CoordinateOperationFactory.class, DefaultCoordinateOperationFactory.class);
        }
        return c;
    }

    public static CoordinateOperationFactory getCoordinateOperationFactory(Map<String, ?> properties, MathTransformFactory mtFactory, CRSFactory crsFactory, CSFactory csFactory) {
        if (Containers.isNullOrEmpty(properties)) {
            if (DefaultFactories.isDefaultInstance(MathTransformFactory.class, mtFactory) && DefaultFactories.isDefaultInstance(CRSFactory.class, crsFactory) && DefaultFactories.isDefaultInstance(CSFactory.class, csFactory)) {
                return CoordinateOperations.factory();
            }
            properties = Collections.emptyMap();
        }
        HashMap p = new HashMap(properties);
        p.putIfAbsent("crsFactory", crsFactory);
        p.putIfAbsent("csFactory", csFactory);
        properties = p;
        return new DefaultCoordinateOperationFactory(properties, mtFactory);
    }

    public static OperationMethod getOperationMethod(Iterable<? extends OperationMethod> methods, String identifier) {
        OperationMethod fallback = null;
        for (OperationMethod operationMethod : methods) {
            if (!NameToIdentifier.isHeuristicMatchForName((IdentifiedObject)operationMethod, identifier) && !NameToIdentifier.isHeuristicMatchForIdentifier(operationMethod.getIdentifiers(), identifier)) continue;
            if (!(operationMethod instanceof Deprecable) || !((Deprecable)operationMethod).isDeprecated()) {
                return operationMethod;
            }
            if (fallback != null) continue;
            fallback = operationMethod;
        }
        return fallback;
    }

    public static boolean isWrapAround(CoordinateSystemAxis axis) {
        return RangeMeaning.WRAPAROUND.equals((Object)axis.getRangeMeaning());
    }

    public static Set<Integer> wrapAroundChanges(CoordinateOperation op) {
        CoordinateReferenceSystem target;
        CoordinateReferenceSystem source;
        if (op instanceof AbstractCoordinateOperation) {
            return ((AbstractCoordinateOperation)op).getWrapAroundChanges();
        }
        if (op != null && (source = op.getSourceCRS()) != null && (target = op.getTargetCRS()) != null) {
            return CoordinateOperations.wrapAroundChanges(source, target.getCoordinateSystem());
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<Integer> wrapAroundChanges(CoordinateReferenceSystem source, CoordinateSystem target) {
        Set<Integer> existing;
        boolean useCache;
        long changes = CoordinateOperations.changes(source.getCoordinateSystem(), target);
        while (source instanceof GeneralDerivedCRS) {
            source = ((GeneralDerivedCRS)source).getBaseCRS();
            changes |= CoordinateOperations.changes(source.getCoordinateSystem(), target);
        }
        boolean bl = useCache = changes >= 0L && changes < (long)CACHE.length;
        if (useCache && (existing = CACHE[(int)changes]) != null) {
            return existing;
        }
        long r = changes;
        Integer[] indices = new Integer[Long.bitCount(r)];
        for (int i = 0; i < indices.length; ++i) {
            int dim = Long.numberOfTrailingZeros(r);
            indices[i] = dim;
            r &= 1L << dim ^ 0xFFFFFFFFFFFFFFFFL;
        }
        Set<Integer> dimensions = JDK9.setOf(indices);
        if (!useCache) return dimensions;
        Set<Integer>[] setArray = CACHE;
        synchronized (CACHE) {
            Set<Integer> existing2 = CACHE[(int)changes];
            if (existing2 != null) {
                // ** MonitorExit[var9_10] (shouldn't be in output)
                return existing2;
            }
            CoordinateOperations.CACHE[(int)changes] = dimensions;
            // ** MonitorExit[var9_10] (shouldn't be in output)
            return dimensions;
        }
    }

    private static long changes(CoordinateSystem source, CoordinateSystem target) {
        long changes = 0L;
        if (source != target) {
            long isWrapAroundAxis = (1 << source.getDimension()) - 1;
            int dim = Math.min(64, target.getDimension());
            block2: for (int i = 0; i < dim; ++i) {
                long mask;
                CoordinateSystemAxis axis = target.getAxis(i);
                if (!CoordinateOperations.isWrapAround(axis)) continue;
                long candidates = isWrapAroundAxis;
                do {
                    CoordinateSystemAxis src;
                    if (!AxisDirections.isColinear((src = source.getAxis(Long.numberOfTrailingZeros(mask = Long.lowestOneBit(candidates)))).getDirection(), axis.getDirection())) continue;
                    try {
                        UnitConverter c = src.getUnit().getConverterToAny(axis.getUnit());
                        double minimum = axis.getMinimumValue();
                        double maximum = axis.getMaximumValue();
                        double tolerance = (maximum - minimum) * 1.0E-13;
                        if (!Numerics.epsilonEqual(c.convert(src.getMinimumValue()), minimum, tolerance) || !Numerics.epsilonEqual(c.convert(src.getMaximumValue()), maximum, tolerance)) {
                            changes |= (long)(1 << i);
                        }
                        if ((isWrapAroundAxis &= mask ^ 0xFFFFFFFFFFFFFFFFL) != 0L) continue block2;
                        break block2;
                    }
                    catch (IncommensurableException incommensurableException) {
                        // empty catch block
                    }
                } while ((candidates &= mask ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
            }
        }
        return changes;
    }

    static {
        CoordinateOperations.add(new CoordinateOperations());
    }
}

