/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.measure.Unit;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.ucar.DimensionWrapper;
import org.apache.sis.internal.netcdf.ucar.GridWrapper;
import org.apache.sis.internal.netcdf.ucar.Utils;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreException;
import org.opengis.referencing.operation.Matrix;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.VariableIF;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.EnhanceScaleMissing;
import ucar.nc2.dataset.Enhancements;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;

final class VariableWrapper
extends Variable {
    private final VariableIF variable;
    private final VariableIF raw;
    private transient Vector values;

    VariableWrapper(Decoder decoder, VariableIF v) {
        super(decoder);
        this.variable = v;
        if (v instanceof VariableEnhanced && (v = ((VariableEnhanced)v).getOriginalVariable()) == null) {
            v = this.variable;
        }
        this.raw = v;
    }

    @Override
    public String getFilename() {
        String name;
        if (this.variable instanceof ucar.nc2.Variable && (name = Utils.nonEmpty(((ucar.nc2.Variable)this.variable).getDatasetLocation())) != null) {
            return name.substring(Math.max(name.lastIndexOf(47), name.lastIndexOf(File.separatorChar)) + 1);
        }
        return super.getFilename();
    }

    @Override
    public String getGroupName() {
        Group parent = this.variable.getParentGroup();
        return parent != null ? parent.getShortName() : null;
    }

    @Override
    public String getName() {
        return this.variable.getShortName();
    }

    @Override
    public String getDescription() {
        return Utils.nonEmpty(this.variable.getDescription());
    }

    @Override
    protected String getUnitsString() {
        String symbol = this.variable.getUnitsString();
        return symbol != null && (symbol = symbol.trim()).isEmpty() ? null : symbol;
    }

    @Override
    protected Unit<?> parseUnit(String symbols) throws Exception {
        if (TIME_UNIT_PATTERN.matcher(symbols).matches()) {
            DateUnit temporal = new DateUnit(symbols);
            this.epoch = temporal.getDateOrigin().toInstant();
            return Units.SECOND.multiply(temporal.getTimeUnit().getValueInSeconds());
        }
        SimpleUnit ucar = SimpleUnit.factoryWithExceptions((String)symbols);
        if (ucar.isUnknownUnit()) {
            return Units.valueOf(symbols);
        }
        String baseUnit = ucar.getUnitString();
        Unit unit = Units.valueOf(baseUnit);
        double scale = ucar.getValue();
        double offset = ucar.convertTo(0.0, SimpleUnit.factoryWithExceptions((String)baseUnit));
        unit = unit.shift(offset);
        if (!Double.isNaN(scale)) {
            unit = unit.multiply(scale);
        }
        return unit;
    }

    @Override
    public DataType getDataType() {
        DataType type;
        switch (this.variable.getDataType()) {
            case STRING: {
                return DataType.STRING;
            }
            case CHAR: {
                return DataType.CHAR;
            }
            case BYTE: {
                type = DataType.BYTE;
                break;
            }
            case SHORT: {
                type = DataType.SHORT;
                break;
            }
            case INT: {
                type = DataType.INT;
                break;
            }
            case LONG: {
                type = DataType.INT64;
                break;
            }
            case FLOAT: {
                return DataType.FLOAT;
            }
            case DOUBLE: {
                return DataType.DOUBLE;
            }
            default: {
                return DataType.UNKNOWN;
            }
        }
        return type.unsigned(this.variable.isUnsigned());
    }

    @Override
    protected boolean isUnlimited() {
        return this.variable.isUnlimited();
    }

    @Override
    protected boolean isCoordinateSystemAxis() {
        return this.variable.isCoordinateVariable();
    }

    @Override
    protected Grid getGrid(Variable.Adjustment adjustment) throws IOException, DataStoreException {
        if (this.variable instanceof Enhancements) {
            Grid[] grids = this.decoder.getGrids();
            List systems = ((Enhancements)this.variable).getCoordinateSystems();
            if (!systems.isEmpty()) {
                GridWrapper grid = null;
                String[] axisNames = this.decoder.convention().namesOfAxisVariables(this);
                for (Grid candidate : grids) {
                    GridWrapper ordered = ((GridWrapper)candidate).forVariable(this.variable, systems, axisNames);
                    if (ordered == null || grid != null && ordered.getSourceDimensions() <= grid.getSourceDimensions()) continue;
                    grid = ordered;
                }
                if (grid != null) {
                    return grid;
                }
            }
        }
        return (GridWrapper)super.getGrid(adjustment);
    }

    @Override
    public List<Dimension> getGridDimensions() {
        return DimensionWrapper.wrap(this.variable.getDimensions());
    }

    @Override
    public Collection<String> getAttributeNames() {
        return VariableWrapper.toNames(this.variable.getAttributes());
    }

    @Override
    public Class<?> getAttributeType(String attributeName) {
        return VariableWrapper.getAttributeType(this.raw.findAttributeIgnoreCase(attributeName));
    }

    static Class<?> getAttributeType(Attribute attribute) {
        if (attribute != null) {
            if (attribute.isArray()) {
                return Vector.class;
            }
            switch (attribute.getDataType()) {
                case BYTE: {
                    return Byte.class;
                }
                case SHORT: {
                    return Short.class;
                }
                case INT: {
                    return Integer.class;
                }
                case LONG: {
                    return Long.class;
                }
                case FLOAT: {
                    return Float.class;
                }
                case DOUBLE: {
                    return Double.class;
                }
                case STRING: {
                    return String.class;
                }
            }
            return Object.class;
        }
        return null;
    }

    @Override
    protected Object getAttributeValue(String attributeName) {
        return VariableWrapper.getAttributeValue(this.raw.findAttributeIgnoreCase(attributeName));
    }

    static Object getAttributeValue(Attribute attribute) {
        if (attribute != null) {
            int length = attribute.getLength();
            switch (length) {
                case 0: {
                    break;
                }
                case 1: {
                    Object value = attribute.getValue(0);
                    if (value instanceof String) {
                        return Utils.nonEmpty((String)value);
                    }
                    if (!(value instanceof Number)) break;
                    return Utils.fixSign((Number)value, attribute.isUnsigned());
                }
                default: {
                    if (attribute.isString()) {
                        boolean hasValues = false;
                        String[] values = new String[length];
                        for (int i = 0; i < length; ++i) {
                            values[i] = Utils.nonEmpty(attribute.getStringValue(i));
                            hasValues |= values[i] != null;
                        }
                        if (!hasValues) break;
                        return values;
                    }
                    Array array = attribute.getValues();
                    return VariableWrapper.createDecimalVector(array.get1DJavaArray(array.getElementType()), attribute.isUnsigned());
                }
            }
        }
        return null;
    }

    static List<String> toNames(List<Attribute> attributes) {
        String[] names = new String[attributes.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = attributes.get(i).getShortName();
        }
        return UnmodifiableArrayList.wrap(names);
    }

    @Override
    protected NumberRange<?> getRangeFallback() {
        EnhanceScaleMissing ev;
        if (this.variable instanceof EnhanceScaleMissing && (ev = (EnhanceScaleMissing)this.variable).hasInvalidData()) {
            return MeasurementRange.create(ev.getValidMin(), true, ev.getValidMax(), true, this.getUnit());
        }
        return super.getRangeFallback();
    }

    @Override
    public Vector read() throws IOException {
        if (this.values == null) {
            Array array = this.variable.read();
            this.values = VariableWrapper.createDecimalVector(this.get1DJavaArray(array), this.variable.isUnsigned());
            this.values = SHARED_VECTORS.unique(this.values);
        }
        return this.values;
    }

    @Override
    public Vector read(GridExtent area, int[] subsampling) throws IOException, DataStoreException {
        Array array;
        int n = area.getDimension();
        int[] lower = new int[n];
        int[] size = new int[n];
        int[] sub = new int[n--];
        for (int i = 0; i <= n; ++i) {
            int j = n - i;
            lower[j] = Math.toIntExact(area.getLow(i));
            size[j] = Math.toIntExact(area.getSize(i));
            sub[j] = subsampling[i];
        }
        try {
            array = this.variable.read(new Section(lower, size, sub));
        }
        catch (InvalidRangeException e) {
            throw new DataStoreException(e);
        }
        return Vector.create(this.get1DJavaArray(array), this.variable.isUnsigned());
    }

    private Object get1DJavaArray(Array array) {
        Object data = array.get1DJavaArray(array.getElementType());
        this.replaceNaN(data);
        return data;
    }

    @Override
    protected double coordinateForAxis(int j, int i) {
        return this.variable instanceof CoordinateAxis2D ? ((CoordinateAxis2D)this.variable).getCoordValue(j, i) : Double.NaN;
    }

    @Override
    protected boolean trySetTransform(Matrix gridToCRS, int srcDim, int tgtDim, Vector values) throws IOException, DataStoreException {
        CoordinateAxis1D axis;
        if (this.variable instanceof CoordinateAxis1D && (axis = (CoordinateAxis1D)this.variable).isRegular()) {
            double start = axis.getStart();
            double increment = axis.getIncrement();
            if (start != 0.0 || increment != 0.0) {
                gridToCRS.setElement(tgtDim, srcDim, increment);
                gridToCRS.setElement(tgtDim, gridToCRS.getNumCol() - 1, start);
                return true;
            }
        }
        return super.trySetTransform(gridToCRS, srcDim, tgtDim, values);
    }

    final boolean isWrapperFor(VariableIF v) {
        return this.variable == v || this.raw == v;
    }
}

