/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.ucar.DecoderWrapper;
import org.apache.sis.internal.netcdf.ucar.DimensionWrapper;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import ucar.nc2.VariableIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;

final class GridWrapper
extends Grid {
    private final CoordinateSystem netcdfCS;
    private final List<ucar.nc2.Dimension> domain;
    private final Map<List<ucar.nc2.Dimension>, GridWrapper> reordered;

    GridWrapper(CoordinateSystem cs) {
        this.netcdfCS = cs;
        this.domain = cs.getDomain();
        this.reordered = new HashMap<List<ucar.nc2.Dimension>, GridWrapper>(4);
    }

    private GridWrapper(GridWrapper parent, List<ucar.nc2.Dimension> dimensions) {
        this.netcdfCS = parent.netcdfCS;
        this.domain = dimensions;
        this.reordered = parent.reordered;
        assert (this.netcdfCS.getDomain().containsAll(dimensions));
    }

    @Override
    protected Grid forDimensions(Dimension[] dimensions) {
        return this.forDimensions(UnmodifiableArrayList.wrap(DimensionWrapper.unwrap(dimensions)));
    }

    private GridWrapper forDimensions(List<ucar.nc2.Dimension> dimensions) {
        if (dimensions.size() > this.domain.size()) {
            dimensions = new ArrayList<ucar.nc2.Dimension>(dimensions);
            dimensions.retainAll(this.domain);
        }
        if (this.domain.equals(dimensions)) {
            return this;
        }
        return this.reordered.computeIfAbsent(dimensions, k -> {
            if (this.domain.size() == k.size() && this.domain.containsAll((Collection<?>)k)) {
                return new GridWrapper(this, (List<ucar.nc2.Dimension>)k);
            }
            return null;
        });
    }

    final GridWrapper forVariable(VariableIF variable, List<CoordinateSystem> systems, String[] axisNames) {
        if (systems.contains(this.netcdfCS) && this.containsAllNamedAxes(axisNames)) {
            return this.forDimensions(variable.getDimensions());
        }
        return null;
    }

    @Override
    public String getName() {
        return this.netcdfCS.getName();
    }

    @Override
    public int getSourceDimensions() {
        return this.netcdfCS.getRankDomain();
    }

    @Override
    public int getTargetDimensions() {
        return this.netcdfCS.getRankRange();
    }

    @Override
    protected List<Dimension> getDimensions() {
        return DimensionWrapper.wrap(this.domain);
    }

    @Override
    protected boolean containsAllNamedAxes(String[] axisNames) {
        if (axisNames != null) {
            block0: for (String name : axisNames) {
                for (CoordinateAxis axis : this.netcdfCS.getCoordinateAxes()) {
                    if (!name.equalsIgnoreCase(axis.getShortName())) continue;
                    continue block0;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected Axis[] createAxes(Decoder decoder) throws IOException, DataStoreException {
        List range = this.netcdfCS.getCoordinateAxes();
        int targetDim = range.size();
        Object[] axes = new Axis[targetDim];
        while (--targetDim >= 0) {
            CoordinateAxis axis = (CoordinateAxis)range.get(targetDim);
            char abbreviation = '\u0000';
            AxisType type = axis.getAxisType();
            if (type != null) {
                switch (type) {
                    case GeoX: {
                        abbreviation = this.netcdfCS.isGeoXY() ? (char)'E' : 'x';
                        break;
                    }
                    case GeoY: {
                        abbreviation = this.netcdfCS.isGeoXY() ? (char)'N' : 'y';
                        break;
                    }
                    case GeoZ: {
                        abbreviation = this.netcdfCS.isGeoXY() ? (char)'H' : 'z';
                        break;
                    }
                    case Lon: {
                        abbreviation = '\u03bb';
                        break;
                    }
                    case Lat: {
                        abbreviation = '\u03c6';
                        break;
                    }
                    case Pressure: 
                    case Height: {
                        abbreviation = 'H';
                        break;
                    }
                    case RunTime: 
                    case Time: {
                        abbreviation = 't';
                        break;
                    }
                    case RadialAzimuth: {
                        abbreviation = '\u03b8';
                        break;
                    }
                    case RadialElevation: {
                        abbreviation = '\u03a9';
                        break;
                    }
                    case RadialDistance: {
                        abbreviation = 'r';
                    }
                }
            }
            int i = 0;
            List axisDomain = axis.getDimensions();
            int[] indices = new int[axisDomain.size()];
            int[] sizes = new int[indices.length];
            for (ucar.nc2.Dimension dimension : axisDomain) {
                int sourceDim = this.domain.lastIndexOf(dimension);
                if (sourceDim < 0) continue;
                indices[i] = sourceDim;
                sizes[i++] = dimension.getLength();
            }
            axes[targetDim] = new Axis(abbreviation, axis.getPositive(), ArraysExt.resize(indices, i), ArraysExt.resize(sizes, i), ((DecoderWrapper)decoder).getWrapperFor((VariableIF)axis));
        }
        int i = Math.min(this.domain.size(), range.size());
        while (--i >= 0) {
            List dimensions = ((CoordinateAxis)range.get(i)).getDimensions();
            if (dimensions.size() == 1 && ((ucar.nc2.Dimension)dimensions.get(0)).equals((Object)this.domain.get(i))) continue;
            return axes;
        }
        ArraysExt.reverse(axes);
        return axes;
    }
}

