/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import org.apache.sis.internal.netcdf.Convention;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.DiscreteSampling;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.ucar.CSBuilderFallback;
import org.apache.sis.internal.netcdf.ucar.FeaturesWrapper;
import org.apache.sis.internal.netcdf.ucar.GridWrapper;
import org.apache.sis.internal.netcdf.ucar.GroupWrapper;
import org.apache.sis.internal.netcdf.ucar.LogAdapter;
import org.apache.sis.internal.netcdf.ucar.Utils;
import org.apache.sis.internal.netcdf.ucar.VariableWrapper;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableIF;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;

public final class DecoderWrapper
extends Decoder
implements CancelTask {
    private final NetcdfFile file;
    private Group[] groups;
    private transient VariableWrapper[] variables;
    private transient FeatureDataset features;
    private transient Grid[] geometries;

    public DecoderWrapper(NetcdfFile file, GeometryLibrary geomlib, StoreListeners listeners) {
        super(geomlib, listeners);
        this.file = file;
        this.groups = new Group[1];
        this.initialize();
    }

    public DecoderWrapper(String filename, GeometryLibrary geomlib, StoreListeners listeners) throws IOException {
        super(geomlib, listeners);
        NetcdfDataset ds = NetcdfDataset.openDataset((String)filename, (boolean)false, (CancelTask)this);
        ds.enhance(Collections.singleton(NetcdfDataset.Enhance.CoordSystems));
        this.file = ds;
        this.groups = new Group[1];
        this.initialize();
    }

    @Override
    public String getFilename() {
        String filename = Utils.nonEmpty(this.file.getLocation());
        if (filename != null) {
            int s = filename.lastIndexOf(File.separatorChar);
            if (s < 0 && File.separatorChar != '/') {
                s = filename.lastIndexOf(47);
            }
            if (s >= 0) {
                filename = filename.substring(s + 1);
            }
        }
        return filename;
    }

    @Override
    public String[] getFormatDescription() {
        String version = Utils.nonEmpty(this.file.getFileTypeVersion());
        String[] format = new String[version != null ? 3 : 2];
        switch (format.length) {
            default: {
                format[2] = version;
            }
            case 2: {
                format[1] = this.file.getFileTypeDescription();
            }
            case 1: {
                format[0] = this.file.getFileTypeId();
            }
            case 0: 
        }
        return format;
    }

    @Override
    public void setSearchPath(String ... groupNames) {
        Group[] groups = new Group[groupNames.length];
        int count = 0;
        for (String name : groupNames) {
            if (name != null) {
                Group group = this.file.findGroup(name);
                if (group == null) continue;
                groups[count] = group;
            }
            ++count;
        }
        this.groups = ArraysExt.resize(groups, count);
    }

    @Override
    public String[] getSearchPath() {
        String[] path = new String[this.groups.length];
        for (int i = 0; i < path.length; ++i) {
            Group group = this.groups[i];
            if (group == null) continue;
            path[i] = group.getShortName();
        }
        return path;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return VariableWrapper.toNames(this.file.getGlobalAttributes());
    }

    private Attribute findAttribute(Group group, String name) {
        String mappedName;
        Attribute value;
        Attribute attribute = value = group != null ? group.findAttributeIgnoreCase(name) : this.file.findGlobalAttributeIgnoreCase(name);
        if (value == null && (mappedName = this.convention().mapAttributeName(name)) != name) {
            value = group != null ? group.findAttributeIgnoreCase(mappedName) : this.file.findGlobalAttributeIgnoreCase(mappedName);
        }
        return value;
    }

    @Override
    public String stringValue(String name) {
        if (name != null) {
            for (Group group : this.groups) {
                Attribute attribute = this.findAttribute(group, name);
                if (attribute == null || !attribute.isString()) continue;
                return Utils.nonEmpty(attribute.getStringValue());
            }
        }
        return null;
    }

    @Override
    public Number numericValue(String name) {
        if (name != null) {
            for (Group group : this.groups) {
                Attribute attribute = this.findAttribute(group, name);
                if (attribute == null) continue;
                Number value = attribute.getNumericValue();
                if (value != null) {
                    return Utils.fixSign(value, attribute.isUnsigned());
                }
                String asString = Utils.nonEmpty(attribute.getStringValue());
                if (asString == null) continue;
                return this.parseNumber(name, asString);
            }
        }
        return null;
    }

    @Override
    public Date dateValue(String name) {
        if (name != null) {
            for (Group group : this.groups) {
                CalendarDate date;
                String value;
                Attribute attribute = this.findAttribute(group, name);
                if (attribute == null || !attribute.isString() || (value = Utils.nonEmpty(attribute.getStringValue())) == null) continue;
                try {
                    date = CalendarDateFormatter.isoStringToCalendarDate((Calendar)Calendar.proleptic_gregorian, (String)value);
                }
                catch (IllegalArgumentException e) {
                    this.listeners.warning(e);
                    continue;
                }
                return new Date(date.getMillis());
            }
        }
        return null;
    }

    @Override
    public Date[] numberToDate(String symbol, Number ... values) {
        DateUnit unit;
        Date[] dates = new Date[values.length];
        try {
            unit = new DateUnit(symbol);
        }
        catch (Exception e) {
            this.listeners.warning(e);
            return dates;
        }
        for (int i = 0; i < values.length; ++i) {
            Number value = values[i];
            if (value == null) continue;
            dates[i] = unit.makeDate(value.doubleValue());
        }
        return dates;
    }

    @Override
    public String getId() {
        return Utils.nonEmpty(this.file.getId());
    }

    @Override
    public String getTitle() {
        return Utils.nonEmpty(this.file.getTitle());
    }

    @Override
    public Variable[] getVariables() {
        if (this.variables == null) {
            List all = this.file.getVariables();
            this.variables = new VariableWrapper[all != null ? all.size() : 0];
            for (int i = 0; i < this.variables.length; ++i) {
                this.variables[i] = new VariableWrapper(this, (VariableIF)all.get(i));
            }
        }
        return this.variables;
    }

    final VariableWrapper getWrapperFor(VariableIF variable) {
        for (VariableWrapper c : (VariableWrapper[])this.getVariables()) {
            if (!c.isWrapperFor(variable)) continue;
            return c;
        }
        return new VariableWrapper(this, variable);
    }

    @Override
    public DiscreteSampling[] getDiscreteSampling() throws IOException, DataStoreException {
        if (this.features == null && this.file instanceof NetcdfDataset) {
            this.features = FeatureDatasetFactoryManager.wrap(null, (NetcdfDataset)((NetcdfDataset)this.file), (CancelTask)this, (Formatter)new Formatter(new LogAdapter(this.listeners), this.listeners.getLocale()));
        }
        List fc = null;
        if (this.features instanceof FeatureDatasetPoint) {
            fc = ((FeatureDatasetPoint)this.features).getPointFeatureCollectionList();
        }
        DiscreteSampling[] wrappers = new FeaturesWrapper[fc != null ? fc.size() : 0];
        try {
            for (int i = 0; i < wrappers.length; ++i) {
                wrappers[i] = new FeaturesWrapper((FeatureCollection)fc.get(i), this.geomlib, this.listeners);
            }
        }
        catch (IllegalArgumentException e) {
            throw new DataStoreException(e.getLocalizedMessage(), e);
        }
        return wrappers;
    }

    @Override
    public Grid[] getGrids() throws IOException {
        if (this.geometries == null) {
            List systems = null;
            if (this.file instanceof NetcdfDataset) {
                NetcdfDataset ds = (NetcdfDataset)this.file;
                EnumSet<NetcdfDataset.Enhance> mode = EnumSet.copyOf(ds.getEnhanceMode());
                if (mode.add(NetcdfDataset.Enhance.CoordSystems)) {
                    ds.enhance(mode);
                }
                if ((systems = ds.getCoordinateSystems()).isEmpty() && this.convention() != Convention.DEFAULT) {
                    CSBuilderFallback builder = new CSBuilderFallback(this);
                    builder.buildCoordinateSystems(ds);
                    systems = ds.getCoordinateSystems();
                }
            }
            this.geometries = new Grid[systems != null ? systems.size() : 0];
            for (int i = 0; i < this.geometries.length; ++i) {
                this.geometries[i] = new GridWrapper((CoordinateSystem)systems.get(i));
            }
        }
        return this.geometries;
    }

    @Override
    protected Node findNode(String name) {
        ucar.nc2.Variable v = this.file.findVariable(name);
        if (v != null) {
            return this.getWrapperFor((VariableIF)v);
        }
        Group group = this.file.findGroup(name);
        return group != null ? new GroupWrapper(this, group) : null;
    }

    public boolean isCancel() {
        return this.canceled;
    }

    public void setProgress(String message, int progress) {
    }

    public void setError(String message) {
        this.listeners.warning(message);
    }

    @Override
    public void close() throws IOException {
        if (this.features != null) {
            this.features.close();
            this.features = null;
        }
        this.file.close();
    }

    public String toString() {
        return "UCAR driver: \u201c" + this.getFilename() + '\u201d';
    }
}

