/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.measure.Unit;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.impl.ChannelDecoder;
import org.apache.sis.internal.netcdf.impl.DimensionInfo;
import org.apache.sis.internal.netcdf.impl.GridInfo;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.HyperRectangleReader;
import org.apache.sis.internal.storage.io.Region;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Numbers;

final class VariableInfo
extends Variable
implements Comparable<VariableInfo> {
    private static final String[] DESCRIPTION_ATTRIBUTES = new String[]{"long_name", "description", "title", "standard_name"};
    private final HyperRectangleReader reader;
    private final String name;
    final DimensionInfo[] dimensions;
    private long offsetToNextRecord;
    private final Map<String, Object> attributes;
    private final DataType dataType;
    GridInfo grid;
    boolean isCoordinateSystemAxis;
    private transient Vector values;
    private final String[] meanings;

    VariableInfo(Decoder decoder, ChannelDataInput input, String name, DimensionInfo[] dimensions, Map<String, Object> attributes, DataType dataType, int size, long offset) throws DataStoreContentException {
        super(decoder);
        Object flags;
        this.name = name;
        this.dimensions = dimensions;
        this.attributes = attributes;
        Object isUnsigned = this.getAttributeValue("_Unsigned", "_unsigned");
        if (isUnsigned instanceof String) {
            dataType = dataType.unsigned(Boolean.valueOf((String)isUnsigned));
        }
        this.dataType = dataType;
        if (dataType != null && (this.offsetToNextRecord = (long)dataType.size()) != 0L) {
            for (int i = 0; i < dimensions.length; ++i) {
                DimensionInfo dim = dimensions[i];
                if (!dim.isUnlimited) {
                    this.offsetToNextRecord = Math.multiplyExact(this.offsetToNextRecord, dim.length());
                    continue;
                }
                if (i == 0) continue;
                throw new DataStoreContentException(this.getLocale(), "netCDF", input.filename, null);
            }
            this.reader = new HyperRectangleReader(dataType.number, input, offset);
        } else {
            this.reader = null;
        }
        if (size != -1) {
            long expected = this.paddedSize();
            long actual = Integer.toUnsignedLong(size);
            if (actual != expected) {
                if (expected != 0L) {
                    this.warning(ChannelDecoder.class, "readVariables", (short)8, this.getFilename(), name, actual - expected);
                }
                if (actual > this.offsetToNextRecord) {
                    this.offsetToNextRecord = actual;
                }
            }
        }
        if (dimensions.length == 1) {
            Object value = this.getAttributeValue("_CoordinateAliasForDimension", "_coordinatealiasfordimension");
            if (value == null && (value = this.getAttributeValue("_CoordinateVariableAlias", "_coordinatevariablealias")) == null) {
                value = name;
            }
            this.isCoordinateSystemAxis = dimensions[0].name.equals(value);
        }
        if (!attributes.isEmpty() && (flags = attributes.remove("flag_meanings")) != null) {
            this.meanings = (String[])CharSequences.split(flags.toString(), ' ');
            return;
        }
        this.meanings = null;
    }

    private long paddedSize() {
        return Math.addExact(this.offsetToNextRecord, 3L) & 0xFFFFFFFFFFFFFFFCL;
    }

    static void complete(VariableInfo[] variables) {
        HashSet<CharSequence> referencedAsAxis = new HashSet<CharSequence>();
        VariableInfo[] unlimited = new VariableInfo[variables.length];
        int count = 0;
        long recordStride = 0L;
        boolean isUnknown = false;
        for (VariableInfo variable : variables) {
            referencedAsAxis.addAll(Arrays.asList(variable.getCoordinateVariables()));
            if (!variable.isUnlimited()) continue;
            long paddedSize = variable.paddedSize();
            unlimited[count++] = variable;
            isUnknown |= paddedSize == 0L;
            recordStride = Math.addExact(recordStride, paddedSize);
        }
        if (isUnknown) {
            for (int i = 0; i < count; ++i) {
                unlimited[i].offsetToNextRecord = -1L;
            }
        } else if (count == 1) {
            unlimited[0].offsetToNextRecord = 0L;
        } else {
            for (int i = 0; i < count; ++i) {
                unlimited[i].offsetToNextRecord = recordStride - unlimited[i].offsetToNextRecord;
            }
        }
        if (!referencedAsAxis.isEmpty()) {
            for (VariableInfo variable : variables) {
                if (!referencedAsAxis.remove(variable.name)) continue;
                variable.isCoordinateSystemAxis = true;
                if (referencedAsAxis.isEmpty()) break;
            }
        }
    }

    @Override
    public String getFilename() {
        String filename;
        if (this.reader != null && (filename = this.reader.filename()) != null) {
            return filename;
        }
        return super.getFilename();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        for (String attributeName : DESCRIPTION_ATTRIBUTES) {
            String value = this.getAttributeAsString(attributeName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    protected String getUnitsString() {
        return this.getAttributeAsString("units");
    }

    @Override
    protected Unit<?> parseUnit(String symbols) {
        Matcher parts = TIME_UNIT_PATTERN.matcher(symbols);
        if (parts.matches()) {
            this.epoch = StandardDateFormat.parseInstantUTC(parts.group(2));
            symbols = parts.group(1);
        }
        return Units.valueOf(symbols);
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    final boolean isEnumeration() {
        return this.meanings != null;
    }

    @Override
    protected boolean isUnlimited() {
        return this.dimensions.length != 0 && this.dimensions[0].isUnlimited;
    }

    @Override
    protected boolean isCoordinateSystemAxis() {
        return this.isCoordinateSystemAxis;
    }

    final String getAxisType() {
        Object value = this.getAttributeValue("_CoordinateAxisType", "_coordinateaxistype");
        return value instanceof String ? (String)value : null;
    }

    final CharSequence[] getCoordinateVariables() {
        return CharSequences.split(this.getAttributeAsString("coordinates"), ' ');
    }

    @Override
    protected Grid getGrid(Variable.Adjustment adjustment) throws IOException, DataStoreException {
        if (this.grid == null) {
            this.decoder.getGrids();
            if (this.grid == null) {
                this.grid = (GridInfo)super.getGrid(adjustment);
            }
        }
        return this.grid;
    }

    @Override
    public List<Dimension> getGridDimensions() {
        return UnmodifiableArrayList.wrap(this.dimensions);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public Class<?> getAttributeType(String attributeName) {
        return Classes.getClass(this.getAttributeValue(attributeName));
    }

    private Object getAttributeValue(String attributeName, String lowerCase) {
        Object value = this.getAttributeValue(attributeName);
        if (value == null) {
            value = this.attributes.get(lowerCase);
        }
        return value;
    }

    @Override
    protected Object getAttributeValue(String attributeName) {
        return this.attributes.get(attributeName);
    }

    final void setValues(Object array) {
        int n;
        Vector data = VariableInfo.createDecimalVector(array, this.dataType.isUnsigned);
        double tolerance = 0.0;
        if (Numbers.isFloat(data.getElementType()) && (n = data.size() - 1) >= 0) {
            double first = data.doubleValue(0);
            double last = data.doubleValue(n);
            double inc = Math.abs((last - first) / (double)n);
            if (!Double.isNaN(inc)) {
                double ulp = Math.ulp(Math.max(Math.abs(first), Math.abs(last)));
                tolerance = Math.min(inc, ulp);
            }
        }
        this.values = data.compress(tolerance);
        this.values = SHARED_VECTORS.unique(this.values);
    }

    @Override
    public Vector read() throws IOException, DataStoreContentException {
        if (this.values == null) {
            float[] copy;
            if (this.reader == null) {
                throw new DataStoreContentException(this.unknownType());
            }
            int dimension = this.dimensions.length;
            long[] lower = new long[dimension];
            long[] upper = new long[dimension];
            int[] subsampling = new int[dimension];
            for (int i = 0; i < dimension; ++i) {
                upper[i] = this.dimensions[dimension - 1 - i].length();
                subsampling[i] = 1;
            }
            Region region = new Region(upper, lower, upper, subsampling);
            this.applyUnlimitedDimensionStride(region);
            Object array = this.reader.read(region);
            this.replaceNaN(array);
            if (array instanceof double[] && (copy = ArraysExt.copyAsFloatsIfLossless((double[])array)) != null) {
                array = copy;
            }
            this.setValues(array);
        }
        return this.values;
    }

    private void applyUnlimitedDimensionStride(Region region) throws DataStoreContentException {
        if (this.isUnlimited()) {
            int dataSize = this.reader.dataSize();
            if (this.offsetToNextRecord < 0L || this.offsetToNextRecord % (long)dataSize != 0L) {
                throw new DataStoreContentException(this.resources().getString((short)6, this.getFilename(), this.name));
            }
            region.increaseStride(this.dimensions.length - 1, this.offsetToNextRecord / (long)dataSize);
        }
    }

    @Override
    public Vector read(GridExtent area, int[] subsampling) throws IOException, DataStoreException {
        if (this.reader == null) {
            throw new DataStoreContentException(this.unknownType());
        }
        if (this.values != null) {
            throw new DataStoreException();
        }
        int dimension = this.dimensions.length;
        long[] size = new long[dimension];
        long[] lower = new long[dimension];
        long[] upper = new long[dimension];
        for (int i = 0; i < dimension; ++i) {
            lower[i] = area.getLow(i);
            upper[i] = Math.incrementExact(area.getHigh(i));
            size[i] = this.dimensions[dimension - 1 - i].length();
        }
        Region region = new Region(size, lower, upper, subsampling);
        this.applyUnlimitedDimensionStride(region);
        Object array = this.reader.read(region);
        this.replaceNaN(array);
        return Vector.create(array, this.dataType.isUnsigned);
    }

    @Override
    protected double coordinateForAxis(int j, int i) throws IOException, DataStoreException {
        assert (j >= 0 && j < this.dimensions[0].length) : j;
        assert (i >= 0 && i < this.dimensions[1].length) : i;
        long n = this.dimensions[1].length();
        return this.read().doubleValue(Math.toIntExact((long)i + n * (long)j));
    }

    final String meaning(int ordinal) {
        return ordinal >= 0 && ordinal < this.meanings.length ? this.meanings[ordinal] : null;
    }

    private String unknownType() {
        return this.resources().getString((short)5, this.getFilename(), this.name, (Object)this.dataType);
    }

    @Override
    public int compareTo(VariableInfo other) {
        int c = Long.compare(this.reader.origin, other.reader.origin);
        if (c == 0) {
            c = this.name.compareTo(other.name);
        }
        return c;
    }
}

