/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.Line;
import org.apache.sis.math.Vector;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.builder.LocalizationGridBuilder;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class SatelliteGroundTrack
extends AbstractMathTransform2D {
    private static final ParameterDescriptorGroup PARAMETERS;
    private final ContextualParameters context;
    private final double \u03bb0;
    private final double slope;
    private final MathTransform2D inverse;

    private SatelliteGroundTrack(LocalizationGridBuilder grid, int lonDim, int direction) throws TransformException {
        Vector latitudes;
        Vector longitudes;
        int median = (int)grid.getSourceEnvelope(false).getMedian(direction ^ 1);
        if (direction == 0) {
            longitudes = grid.getRow(lonDim, median);
            latitudes = grid.getRow(lonDim ^ 1, median);
        } else {
            longitudes = grid.getColumn(lonDim, median);
            latitudes = grid.getColumn(lonDim ^ 1, median);
        }
        Line line = new Line();
        line.fit(latitudes, longitudes);
        this.\u03bb0 = line.y0();
        this.slope = Math.toRadians(line.slope());
        this.inverse = new Inverse();
        this.context = new ContextualParameters(PARAMETERS, 2, 2);
        MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        normalize.convertAfter(1, DoubleDouble.createDegreesToRadians(), null);
        this.setPositionParameter("central_meridian_start", line, latitudes.doubleValue(0));
        this.setPositionParameter("central_meridian_end", line, latitudes.doubleValue(latitudes.size() - 1));
    }

    private void setPositionParameter(String name, Line line, double \u03c6) {
        DirectPosition2D pos = new DirectPosition2D(\u03c6, line.y(\u03c6));
        this.context.parameter(name).setValue((Object)pos);
    }

    static MathTransform create(MathTransformFactory factory, LocalizationGridBuilder grid, int lonDim, int direction) throws TransformException, FactoryException {
        SatelliteGroundTrack tr = new SatelliteGroundTrack(grid, lonDim, direction);
        return tr.context.completeTransform(factory, tr);
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.context;
    }

    @Override
    protected ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double cos\u03c6 = Math.cos(\u03c6);
        double m = \u03c6 * this.slope + this.\u03bb0;
        double \u0394\u03bb = \u03bb - m;
        if (dstPts != null) {
            dstPts[dstOff] = \u0394\u03bb * cos\u03c6 + m;
            dstPts[dstOff + 1] = \u03c6;
        }
        if (!derivate) {
            return null;
        }
        Matrix2 d = new Matrix2();
        d.m00 = cos\u03c6;
        d.m01 = this.slope * (1.0 - cos\u03c6) - \u0394\u03bb * Math.sin(\u03c6);
        return d;
    }

    @Override
    public MathTransform2D inverse() {
        return this.inverse;
    }

    static {
        ParameterBuilder builder = new ParameterBuilder().setRequired(true);
        ParameterDescriptor[] grids = new ParameterDescriptor[]{((ParameterBuilder)builder.addName("central_meridian_start")).create(DirectPosition.class, null), ((ParameterBuilder)builder.addName("central_meridian_end")).create(DirectPosition.class, null)};
        PARAMETERS = ((ParameterBuilder)builder.addName("Satellite ground track")).createGroup((GeneralParameterDescriptor[])grids);
    }

    private final class Inverse
    extends AbstractMathTransform2D.Inverse {
        Inverse() {
        }

        @Override
        public MathTransform2D inverse() {
            return SatelliteGroundTrack.this;
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            double x = srcPts[srcOff];
            double \u03c6 = srcPts[srcOff + 1];
            double cos\u03c6 = Math.cos(\u03c6);
            double m = \u03c6 * SatelliteGroundTrack.this.slope + SatelliteGroundTrack.this.\u03bb0;
            double \u0394x = x - m;
            if (dstPts != null) {
                dstPts[dstOff] = \u0394x / cos\u03c6 + m;
                dstPts[dstOff + 1] = \u03c6;
            }
            if (!derivate) {
                return null;
            }
            Matrix2 d = new Matrix2();
            d.m00 = 1.0 / cos\u03c6;
            d.m01 = (\u0394x * Math.sin(\u03c6) / cos\u03c6 - SatelliteGroundTrack.this.slope) / cos\u03c6 + SatelliteGroundTrack.this.slope;
            return d;
        }
    }
}

