/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.awt.image.DataBuffer;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.ImageRenderer;
import org.apache.sis.internal.coverage.BufferedGridCoverage;
import org.apache.sis.internal.netcdf.Resources;

final class Raster
extends BufferedGridCoverage {
    private final int pixelStride;
    private final int[] bandOffsets;
    private final String label;

    Raster(GridGeometry domain, List<SampleDimension> range, DataBuffer data, int pixelStride, int[] bandOffsets, String label) {
        super(domain, range, data);
        this.label = label;
        this.pixelStride = pixelStride;
        this.bandOffsets = bandOffsets;
    }

    @Override
    public RenderedImage render(GridExtent target) {
        try {
            ImageRenderer renderer = new ImageRenderer(this, target);
            renderer.setData(this.data);
            if (this.bandOffsets != null) {
                renderer.setInterleavedPixelOffsets(this.pixelStride, this.bandOffsets);
            }
            return renderer.image();
        }
        catch (RasterFormatException | ArithmeticException | IllegalArgumentException e) {
            throw new RuntimeException(Resources.format((short)14, this.label, e), e);
        }
    }
}

