/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

public enum DataType {
    UNKNOWN(0, false, false, 0, 32),
    BYTE(3, true, false, 7, 0),
    CHAR(3, false, true, 2, 32),
    SHORT(4, true, false, 8, 2),
    INT(5, true, false, 9, 3),
    FLOAT(8, false, false, 5, 4),
    DOUBLE(9, false, false, 6, 5),
    UBYTE(3, true, true, 1, 0),
    USHORT(4, true, true, 3, 1),
    UINT(5, true, true, 4, 3),
    INT64(6, true, false, 11, 32),
    UINT64(6, true, true, 10, 32),
    STRING(0, false, false, 12, 32);

    public final byte number;
    public final boolean isInteger;
    public final boolean isUnsigned;
    private final byte opposite;
    public final int rasterDataType;
    private static final DataType[] VALUES;

    private DataType(byte number, boolean isInteger, boolean isUnsigned, byte opposite, int rasterDataType) {
        this.number = number;
        this.isInteger = isInteger;
        this.isUnsigned = isUnsigned;
        this.opposite = opposite;
        this.rasterDataType = rasterDataType;
    }

    public final int size() {
        switch (this.number) {
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: 
            case 8: {
                return 4;
            }
            case 6: 
            case 9: {
                return 8;
            }
        }
        return 0;
    }

    public final DataType unsigned(boolean u) {
        return u == this.isUnsigned ? this : DataType.valueOf(this.opposite);
    }

    public static DataType valueOf(int code) {
        return code >= 0 && code < VALUES.length ? VALUES[code] : UNKNOWN;
    }

    static {
        VALUES = DataType.values();
    }
}

